/*	plarea.c

        Fill area within polygon.
*/

#include "plplot.h"
#define MAXPOLYGON 20

void placlp();

#ifdef PLSTDC
void c_plarea(PLINT n, PLFLT *x, PLFLT *y, PLFLT grey)
#else
void 
c_plarea(n, x, y, grey)
PLINT n;
PLFLT *x, *y;
PLFLT grey;
#endif
{
    PLINT i, level;
    PLINT xp[MAXPOLYGON], yp[MAXPOLYGON];
    PLINT x1, x2, y1, y2;
    int m;

    glev(&level);
    if (level < 3)
      plexit("Please set up window before calling plline.");
    if (n > MAXPOLYGON) plexit("Polygon too complex.");

    m = 0;
    for (i = 1; i < n; i++) {
        x1 = wcpcx(x[i-1]); 
        y1 = wcpcy(y[i-1]);
        x2 = wcpcx(x[i]); 
        y2 = wcpcy(y[i]);
	placlp(&x1, &y1, &x2, &y2);
	if (x1 == 0 && x2 == 0 && y1 == 0 && y2 == 0) continue;
	xp[m] = x1;
	yp[m] = y1;
	xp[m+1] = x2;
	yp[m+1] = y2;
	m += 2;
	if (m > MAXPOLYGON) plexit("Polygon too complex.");
    }
    n = m;
    m = 1;
    for (i = 1; i < n; i++) {
	if (xp[i] != xp[i-1] || yp[i] != yp[i-1]) {
	    xp[m] = xp[i];
	    yp[m] = yp[i];
	    m++;
	} 
    }
    n = m;
    if ((xp[0] != xp[n-1]) || (yp[0] != yp[n-1])) {
	n++;
	xp[n-1] = xp[0];
	yp[n-1] = yp[0];
    }
    grarea(n, xp, yp, grey);
}

/*	placlp.c

	Clips a line from (x1,y1) to (x2,y2) to clip limits.
*/

#define INSIDE(ix,iy) (BETW(ix,clpxmi,clpxma) && BETW(iy,clpymi,clpyma))

void 
placlp(x1, y1, x2, y2)
PLINT *x1, *y1, *x2, *y2;
{
    PLINT clpxmi, clpxma, clpymi, clpyma;
    PLINT t, dx, dy, flipx, flipy;
    PLFLT slope;

    gclp(&clpxmi, &clpxma, &clpymi, &clpyma);

    if (INSIDE(*x1, *y1) && INSIDE(*x2, *y2)) return;

    if ((*x1 <= clpxmi && *x2 <= clpxmi) || (*x1 >= clpxma && *x2 >= clpxma)) {
	*x1 = *x2 = *y1 = *y2 = 0;
	return;
    }
    if ((*y1 <= clpymi && *y2 <= clpymi) || (*y1 >= clpyma && *y2 >= clpyma)) {
	*x1 = *x2 = *y1 = *y2 = 0;
	return;
    }

    flipx = 0;
    flipy = 0;

    if (*x2 < *x1) {
	*x1 = 2 * clpxmi - *x1;
	*x2 = 2 * clpxmi - *x2;
	clpxma = 2 * clpxmi - clpxma;
	t = clpxma;
	clpxma = clpxmi;
	clpxmi = t;
	flipx = 1;
    }

    if (*y2 < *y1) {
	*y1 = 2 * clpymi - *y1;
	*y2 = 2 * clpymi - *y2;
	clpyma = 2 * clpymi - clpyma;
	t = clpyma;
	clpyma = clpymi;
	clpymi = t;
	flipy = 1;
    }

    dx = *x2 - *x1;
    dy = *y2 - *y1;

    if (dx != 0) 
      slope = (double) dy / (double) dx;

    if (*x1 < clpxmi) {
	if (dx != 0 && dy != 0)
	  *y1 = *y1 + ROUND(slope * (clpxmi - *x1));
	*x1 = clpxmi;
    }

    if (*y1 < clpymi) {
	if (dx != 0 && dy != 0)
	  *x1 = *x1 + ROUND((clpymi - *y1) / slope);
	*y1 = clpymi;
    }

    if (*x1 >= clpxma || *y1 >= clpyma) {
	*x1 = *x2 = *y1 = *y2 = 0;
	return;
    }

    if (*y2 > clpyma) {
	if (dx != 0 && dy != 0)
	  *x2 = *x2 - ROUND((*y2 - clpyma) / slope);
	*y2 = clpyma;
    }

    if (*x2 > clpxma) {
	if (dx != 0 && dy != 0)
	  *y2 = *y2 - ROUND((*x2 - clpxma) * slope);
	*x2 = clpxma;
    }

    if (flipx) {
	*x1 = 2 * clpxma - *x1;
	*x2 = 2 * clpxma - *x2;
	clpxmi = 2 * clpxma - clpxmi;
	t = clpxma;
	clpxma = clpxmi;
	clpxmi = t;
    }

    if (flipy) {
	*y1 = 2 * clpyma - *y1;
	*y2 = 2 * clpyma - *y2;
	clpymi = 2 * clpyma - clpymi;
	t = clpyma;
	clpyma = clpymi;
	clpymi = t;
    }
    return;
}

