/*	plform.c

	Controls format of floating point value in axes labels.
*/

#include "plplot.h"
#include <stdio.h>
#ifdef PLSTDC
#include <string.h>
#else
extern char *strcpy();
extern char *strcat();
#endif
#include <math.h>

static PLINT setpre, precis;

/*----------------------------------------------------------------------*\
* void plprec()
*
* Set the number of points written after the decimal point in labels.
\*----------------------------------------------------------------------*/

void
c_plprec(setp, prec)
PLINT setp, prec;
{
    setpre = setp;
    precis = prec;
}

/*----------------------------------------------------------------------*\
* void plform()
*
* Formats a floating point value in one of the following formats 
* (i)	If scale == 0, use floating point format with "prec" places
*	after the decimal point. 
* (ii)	If scale == 1, use scientific notation with one place before 
*	the decimal point and "prec" places after.  In this case, the
*	value must be divided by 10^scale.
\*----------------------------------------------------------------------*/

#ifdef PLSTDC
void
plform(PLFLT value, PLINT scale, PLINT prec, char *result)
#else
void
plform(value, scale, prec, result)
PLFLT value;
PLINT scale, prec;
char *result;
#endif
{
    char form[10];
    char temp[30];

    if(setpre)
	prec = precis;

    if(scale)
	value /= pow(10.,(double)scale);

    sprintf(form, "%%.%df", prec);
    sprintf(temp, form, value);
    strcpy(result, temp);
}

