C***********************************************************************
C
C  sfstubs.f
C
C  This file contains all the fortran stub routines.
C
C***********************************************************************

	subroutine plsfnam(fnam)

	character*(*) fnam

	parameter (maxlen = 101, maxchar = (maxlen-1)*4)
	integer*4 string1(maxlen), string2(maxlen), string3(maxlen)
	integer*4 string4(maxlen), string5(maxlen), string6(maxlen)
	common /strings/ string1,string2,string3,string4,string5,string6

	limit = min(islen(fnam),maxchar)
	call str2int(fnam, string1, limit)
	call plsfnam_(string1)

	end

C***********************************************************************

	subroutine plgfnam(fnam)

	character*(*) fnam

	parameter (maxlen = 101, maxchar = (maxlen-1)*4)
	integer*4 string1(maxlen), string2(maxlen), string3(maxlen)
	integer*4 string4(maxlen), string5(maxlen), string6(maxlen)
	common /strings/ string1,string2,string3,string4,string5,string6

	call plgfnam_(string1)
	limit = min(islen(fnam),maxchar)
	call int2str(string1, fnam, limit)

	end

C***********************************************************************

	subroutine plaxes(x0,y0,xopt,xtick,nxsub,yopt,ytick,nysub)

	real	x0, y0, xtick, ytick
	integer nxsub, nysub
	character*(*) xopt,yopt

	parameter (maxlen = 101, maxchar = (maxlen-1)*4)
	integer*4 string1(maxlen), string2(maxlen), string3(maxlen)
	integer*4 string4(maxlen), string5(maxlen), string6(maxlen)
	common /strings/ string1,string2,string3,string4,string5,string6
	integer limit

	limit = min(islen(xopt),maxchar)
	call str2int(xopt, string1, limit)

	limit = min(islen(yopt),maxchar)
	call str2int(yopt, string2, limit)

	call plaxes_(x0,y0,string1,xtick,nxsub,string2,ytick,nysub)

	end

C***********************************************************************

	subroutine plbox(xopt,xtick,nxsub,yopt,ytick,nysub)

	real	xtick, ytick
	integer nxsub, nysub
	character*(*) xopt,yopt

	parameter (maxlen = 101, maxchar = (maxlen-1)*4)
	integer*4 string1(maxlen), string2(maxlen), string3(maxlen)
	integer*4 string4(maxlen), string5(maxlen), string6(maxlen)
	common /strings/ string1,string2,string3,string4,string5,string6
	integer limit

	limit = min(islen(xopt),maxchar)
	call str2int(xopt, string1, limit)

	limit = min(islen(yopt),maxchar)
	call str2int(yopt, string2, limit)

	call plbox_(string1,xtick,nxsub,string2,ytick,nysub)

	end

C***********************************************************************

	subroutine plbox3(xopt,xlabel,xtick,nxsub,yopt,ylabel,ytick,nysub,
     *		    zopt,zlabel,ztick,nzsub)

	real	xtick, ytick, ztick
	character*(*) xopt,xlabel,yopt,ylabel,zopt,zlabel
	integer nxsub, nysub, nzsub

	parameter (maxlen = 101, maxchar = (maxlen-1)*4)
	integer*4 string1(maxlen), string2(maxlen), string3(maxlen)
	integer*4 string4(maxlen), string5(maxlen), string6(maxlen)
	common /strings/ string1,string2,string3,string4,string5,string6

	limit = min(islen(xopt),maxchar)
	call str2int(xopt, string1, limit)

	limit = min(islen(xlabel),maxchar)
	call str2int(xlabel, string2, limit)

	limit = min(islen(yopt),maxchar)
	call str2int(yopt, string3, limit)

	limit = min(islen(ylabel),maxchar)
	call str2int(ylabel, string4, limit)

	limit = min(islen(zopt),maxchar)
	call str2int(zopt, string5, limit)

	limit = min(islen(zlabel),maxchar)
	call str2int(zlabel, string6, limit)

	call plbox3_(string1,string2,xtick,nxsub,
     *	       string3,string4,ytick,nysub,
     *	       string5,string6,ztick,nzsub)

	end

C***********************************************************************

	subroutine plcon0(z,nx,ny,kx,lx,ky,ly,clevel,nlevel)
	call plcon0_(z,nx,ny,kx,lx,ky,ly,clevel,nlevel)
	end

C***********************************************************************

	subroutine plcon1(z,nx,ny,kx,lx,ky,ly,clevel,nlevel,xg,yg)
	call plcon1_(z,nx,ny,kx,lx,ky,ly,clevel,nlevel,xg,yg)
	end

C***********************************************************************

	subroutine plcon2(z,nx,ny,kx,lx,ky,ly,clevel,nlevel,xg,yg)
	call plcon2_(z,nx,ny,kx,lx,ky,ly,clevel,nlevel,xg,yg)
	end

C***********************************************************************

	subroutine plcont(z,nx,ny,kx,lx,ky,ly,clevel,nlevel)

	real	z, clevel
	integer nx, ny, kx, lx, ky, ly, nlevel
	real tr
	common /plplot/ tr(6)

	call plcont_(z,nx,ny,kx,lx,ky,ly,clevel,nlevel,tr)

	end

C***********************************************************************

	subroutine pllab(xlab,ylab,title)

	character*(*) xlab,ylab,title

	parameter (maxlen = 101, maxchar = (maxlen-1)*4)
	integer*4 string1(maxlen), string2(maxlen), string3(maxlen)
	integer*4 string4(maxlen), string5(maxlen), string6(maxlen)
	common /strings/ string1,string2,string3,string4,string5,string6
	integer limit

	limit = min(islen(xlab),maxchar)
	call str2int(xlab, string1, limit)

	limit = min(islen(ylab),maxchar)
	call str2int(ylab, string2, limit)

	limit = min(islen(title),maxchar)
	call str2int(title, string3, limit)
	
	call pllab_(string1,string2,string3)

	end

C***********************************************************************

	subroutine plancol(icolor, name)

	integer icolor
	character*(*) name

	parameter (maxlen = 101, maxchar = (maxlen-1)*4)
	integer*4 string1(maxlen), string2(maxlen), string3(maxlen)
	integer*4 string4(maxlen), string5(maxlen), string6(maxlen)
	common /strings/ string1,string2,string3,string4,string5,string6
	integer limit

	limit = min(islen(name),maxchar)
	call str2int(name, string1, limit)

	call plancol_(icolor, string1)

	end

C***********************************************************************

	subroutine plmtex(side,disp,pos,xjust,text)

	real	disp, pos, xjust
	character*(*) side, text

	parameter (maxlen = 101, maxchar = (maxlen-1)*4)
	integer*4 string1(maxlen), string2(maxlen), string3(maxlen)
	integer*4 string4(maxlen), string5(maxlen), string6(maxlen)
	common /strings/ string1,string2,string3,string4,string5,string6
	integer limit

	limit = min(islen(side),maxchar)
	call str2int(side, string1, limit)

	limit = min(islen(text),maxchar)
	call str2int(text, string2, limit)

	call plmtex_(string1,disp,pos,xjust,string2)

	end

C***********************************************************************

	subroutine plptex(x,y,dx,dy,xjust,text)

	real	x, y, dx, dy, xjust
	character*(*) text

	parameter (maxlen = 101, maxchar = (maxlen-1)*4)
	integer*4 string1(maxlen), string2(maxlen), string3(maxlen)
	integer*4 string4(maxlen), string5(maxlen), string6(maxlen)
	common /strings/ string1,string2,string3,string4,string5,string6
	integer limit

	limit = min(islen(text),maxchar)
	call str2int(text, string1, limit)
	call plptex_(x,y,dx,dy,xjust,string1)

	end

C***********************************************************************

	subroutine plstart(devname, nx, ny)

	character*(*) devname
	integer nx, ny

	parameter (maxlen = 101, maxchar = (maxlen-1)*4)
	integer*4 string1(maxlen), string2(maxlen), string3(maxlen)
	integer*4 string4(maxlen), string5(maxlen), string6(maxlen)
	common /strings/ string1,string2,string3,string4,string5,string6
	integer limit

	limit = min(islen(devname),maxchar)
	call str2int(devname, string1, limit)
	call plstart_(string1, nx, ny)

	end

C***********************************************************************
