/*	starbase.c

	PLPLOT starbase device driver.
*/
#ifndef HPUX
#undef STARBASE
#endif

#ifdef STARBASE

#include <starbase.c.h>
#include <stdio.h>
#include "plplot.h"
#ifdef PLSTDC
#include <string.h>
#endif

#include "dispatch.h"

/* Function prototypes */

static void	begplt		PLARGS((PLStream *));
static void	setcol		PLARGS((long));
static void	endplt		PLARGS((void));
static void	erase		PLARGS((void));
static void	getkey		PLARGS((int *));
static int 	getwcur		PLARGS((float *, float *));

#define PLSB_MAX 32767

#define PLSB_X	PLSB_MAX	/* Number of virtual pixels in x */
#define PLSB_Y	PLSB_MAX	/* Number of virtual pixels in y */

/* top level declarations */

/* Stuff to handle reentrancy for multiple streams/devices.
   This is still under development so use caution. Right now there
   is no multiple device capability beyond that of multiple streams. */

#define PL_NDEV_SB  10	/* Max number of X sessions active */
#define PL_NDEVICES 10	/* Max number of devices/stream active */

typedef struct {
    int fildes;
    int monochrome;
} SbDev;

static SbDev sbdev[PL_NDEV_SB];
static PLDev pldev[PL_NDEV_SB];

static SbDev *sbd;
static PLDev *pld;
static int id, idev = -1;
static int devtable[PL_NSTREAMS][PL_NDEVICES];

/*----------------------------------------------------------------------*\
* sb_init()
*
* Initialize device.
* starbase-dependent stuff done in begplt().
\*----------------------------------------------------------------------*/

void 
sb_init(pls)
PLStream *pls;
{
    if (++idev == PL_NDEV_SB)
	plexit("Exceeded maximum number of active X sessions.");

    devtable[pls->ipls][pls->ipld] = idev;

    pld = &(pldev[idev]);
    sbd = &(sbdev[idev]);

    pls->termin = 1;		/* is an interactive terminal */
    pls->color = 1;
    pls->width = 1;
    pls->bytecnt = 0;
    pls->page = 0;

    begplt(pls);

    pld->xold = UNDEFINED;
    pld->yold = UNDEFINED;
    pld->xmin = 0;
    pld->xmax = PLSB_X;
    pld->ymin = 0;
    pld->ymax = PLSB_Y;

    setpxl(4.771 * 2, 4.653 * 2);
    setphy(pld->xmin, pld->xmax, pld->ymin, pld->ymax);
}

/*----------------------------------------------------------------------*\
* sb_line()
*
* Draw a line in the current color from (x1,y1) to (x2,y2).
\*----------------------------------------------------------------------*/

void 
sb_line(pls, x1a, y1a, x2a, y2a)
PLStream *pls;
PLINT x1a, y1a, x2a, y2a;
{
    int x1, y1, x2, y2;

    id = devtable[pls->ipls][pls->ipld];
    sbd = &(sbdev[id]);

    x1 = x1a;
    y1 = y1a;
    x2 = x2a;
    y2 = y2a;

    if (pls->pscale)
	plSclPhy(pls, pld, &x1, &y1, &x2, &y2);

    intmove2d(sbd->fildes, x1, y1);
    intdraw2d(sbd->fildes, x2, y2);
}

/*----------------------------------------------------------------------*\
* sb_clear()
*
* Clear page.
\*----------------------------------------------------------------------*/

void 
sb_clear(pls)
PLStream *pls;
{
    int intrpt, but;
    float x, y;

    id = devtable[pls->ipls][pls->ipld];
    sbd = &(sbdev[id]);

    erase();
}

/*----------------------------------------------------------------------*\
* sb_page()
*
* Set up for the next page.
\*----------------------------------------------------------------------*/

void 
sb_page(pls)
PLStream *pls;
{
    pls->page++;
}

/*----------------------------------------------------------------------*\
* sb_adv()
*
* Advance to the next page.
\*----------------------------------------------------------------------*/

void 
sb_adv(pls)
PLStream *pls;
{
    sb_clear(pls);
    sb_page(pls);
}

/*----------------------------------------------------------------------*\
* sb_tidy()
*
* Close graphics file
\*----------------------------------------------------------------------*/

void 
sb_tidy(pls)
PLStream *pls;
{
    int intrpt, but;

    id = devtable[pls->ipls][pls->ipld];
    sbd = &(sbdev[id]);

    endplt();
    pls->fileset = 0;
    pls->page = 0;
    pls->OutFile = NULL;
    idev--;
}

/*----------------------------------------------------------------------*\
* sb_color()
*
* Set pen color.
\*----------------------------------------------------------------------*/

void 
sb_color(pls)
PLStream *pls;
{
    id = devtable[pls->ipls][pls->ipld];
    sbd = &(sbdev[id]);

    setcol(pls->color);
}

/*----------------------------------------------------------------------*\
* sb_text()
*
* Switch to text mode.
\*----------------------------------------------------------------------*/

void 
sb_text(pls)
PLStream *pls;
{
}

/*----------------------------------------------------------------------*\
* sb_graph()
*
* Switch to graphics mode.
\*----------------------------------------------------------------------*/

void 
sb_graph(pls)
PLStream *pls;
{
}

/*----------------------------------------------------------------------*\
* sb_width()
*
* Set pen width.
\*----------------------------------------------------------------------*/

void
sb_width (pls)
PLStream *pls;
{
}

/*----------------------------------------------------------------------*\
* sb_esc()
*
* Escape function.
\*----------------------------------------------------------------------*/

void 
sb_esc(pls, op, ptr)
PLStream *pls;
PLINT op;
char *ptr;
{
    id = devtable[pls->ipls][pls->ipld];
    sbd = &(sbdev[id]);

    switch (op) {
    case PL_SET_RGB:
	break;

    case PL_ALLOC_NCOL:
	break;
    }
}

/*----------------------------------------------------------------------*\
* Main initialization routine.
\*----------------------------------------------------------------------*/

static void
begplt(pls)
PLStream *pls;
{
    int distort = 1;

    sbd->fildes = gopen("/dev/screen/DRPwindow", OUTDEV, "sox11", INT_XFORM);
    if (sbd->fildes == -1) {
	fprintf(stderr, "can't open 'DRPwindow'\n");
	exit(-1);
    }
    mapping_mode(sbd->fildes, distort);
    intvdc_extent(sbd->fildes, 0, 0, PLSB_X, PLSB_Y);
}

/*----------------------------------------------------------------------*\
* Set color.
\*----------------------------------------------------------------------*/

static void
setcol(icol)
long icol;
{
}

static void
endplt()
{
    gclose(sbd->fildes);
}

static void
erase()
{
    clear_view_surface(sbd->fildes);
}

static void
getkey(intrpt)
int *intrpt;
{
}

static int 
getwcur(x, y)
float *x, *y;
{
}

#endif	/* STARBASE */
