/* Test of drawing a histogram */
/* Note the compiler should automatically convert all non-pointer arguments
   to satisfy the prototype, but some have problems with constants. */

#include "plplot.h"
#include <math.h>

main()
{
    int i;
    static PLFLT xp[5];
    static PLFLT yp[5];
    PLFLT xmin, xmax, ymin, ymax;
    PLFLT grey;

    /* Fill up data points */

    plstar(1, 1);
    xmin = 0.0; xmax = 14.0;
    ymin = 0.0; ymax = 1.0;
    plenv(xmin, xmax, ymin, ymax, 0, 0);

    yp[0] = ymin;
    yp[1] = ymin;
    yp[2] = ymax;
    yp[3] = ymax;
    yp[4] = ymin;
    for (i=1; i<=14; i++) {
	plcol(i);
	xp[0] = (PLFLT)(i-1);
	xp[1] = (PLFLT)i;
	xp[2] = (PLFLT)i;
	xp[3] = (PLFLT)(i-1);
	xp[4] = (PLFLT)(i-1);
	grey = (PLFLT)i/28.0;
/*	grey = -1.0; */
	printf("x05c: shade = %f\n", grey);
	plarea(5, xp, yp, grey);
    }

    plend();
}







