#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifndef PI
#define PI 3.14159265358979323844
#endif
#define RADTODEG (180.0/PI)

static char str[13];

char *angle(double rad, int sys)
{
   double deg, secs;
   long ms;
   int d, m;

   deg = rad*RADTODEG;
   if (sys < 2) {
       ms = (long)(fabs(deg)*3600.0*1000.0);   /* milliseconds */
       if (sys == 1) ms /= 15;
       d = ms/3600/1000;
       if (deg < 0.0) d = -d;
       m = (ms/60/1000)%60;
       secs = (double)(ms%60000)/1000.0;
       if (sys == 0) sprintf (str,"%3dd%02d'%04.1f\"", d, m, secs);
       if (sys == 1) sprintf (str,"%3dh%02dm%04.1fs",  d, m, secs);
       if (deg < 0.0) str[0] = '-';
       if (abs(d) < 10) str[1] = '0'; 
   } else sprintf (str,"%12.6fd", deg);
   return (str);
}

