#define ANTSHEADER 300
#define ANTSMAXCH 1024

typedef struct {
   short x[2][3];
} extended;

struct dfscan {
   short ScanNo;
   short RefScanNo;
   char Observer[12];
   char Project[8];
   char Source[12];
   short AtmosAtt;     /* 3=chopper,2=sky,1=prec.water,0=undefined */
   short unused1[2];
   short Revision;
   float LST;
   float UTC;
   short CalScanNo;
   short Month;
   short Day;
   short Year;
   short ObsType;      /* 2=off,1=on,0=undefined */
   short DisType;      /* 5=cal,4=ave,3=spe,2=off,1=on,0=undefined */
   short CalMode;      /* 2=dBl and Tref,1=dBcal and Tcal,0=undefined */
   short Telescope;    /* 20=OSO 20m,25=OSO 20m,15 SEST */
   float RArate;
   float DErate;
   float VertAtt;
   float ActAtt;
   extended RADecRef;
   float RefEpoch;
   extended RADecAct;
   float ActEpoch;
   extended RADecOut;
   extended Galactic;
   extended RestFreq;
   extended SkyFreq;
   float Tcal[2];
   float IntTime[2];
   float Tsys[2];
   float wTime[2];
   float VSource[2];
   float VelRes[2];
   float Bandwidth[2];
   float NChannels[2];
   float POPS1[2];
   short unused2[2];
   extended LO[3];
   short unused3[6];
   float SubRef[5];
   float AirTemp;
   float Pressure;
   float RelHumid;
   float AbsHumid;
   short CorrMode;
   short CorrWeight;       /* 0=no weighting */
   extended AzElOut;
   float AzPointing;
   float ElPointing;
   float Refraction;
   float AzOffset;
   float ElOffset;
   float RAOffset;
   float DEOffset;
   float ElReadout;
   float CalAtt;
   float CalElv;
   float IntTimeWf;
   short unused4[6];
   float RxSelect[3];
   float RxMode;
   float AtmTemp;
   float Chopper;
   float NTPower[8];
   short unused5[32];
   float Tau;
   char Molecule[18];
   short code;
   short MapX;
   short MapY;
   short unused6[2];
   short NColX;
   short NColY;
   short RefColX;
   short RefColY;
   float StepX;
   float StepY;
   float PosAngle;
   char free[28];
   short NPhase;
   short TotNCh;
   float Channels[ANTSMAXCH];
};
