#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "drp.h"
#include "options.h"

#define MAXRANGE 10
 
static double Range[MAXRANGE];
static int nw = 0;
int xUnit = VELOCITY;

int VChannel(double , SCAN *);
int FChannel(double , SCAN *);

char PROGRAM_NAME[] = "area";
char description[] = "integrate intensity over up to 5 intervals";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-vel v1 v2",		"select velocity range(s) (up to 5)" },
{ "-freq f1 f2",	"select frequency range(s) (up to 5)" },
{ "-chan c1 c2",	"select channel range(s) (up to 5)" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "vel")) {
	if (nw == MAXRANGE) Syntax("-vel");
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	xUnit = VELOCITY;
	return;
    }
    if (!strcmp(opt, "freq")) {
	if (nw == MAXRANGE) Syntax("-freq");
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	xUnit = FREQUENCY;
	return;
    }
    if (!strcmp(opt, "chan")) {
	if (nw == MAXRANGE) Syntax("-chan");
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	xUnit = CHANNELS;
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main (int argc, char *argv[])
{
    FILE *lf;
    float offx, offy;
    double sum, area[MAXRANGE/2];
    int Window[MAXRANGE], start, stop;
    int  i, j, l;

    GetOpts(argc, argv);
    GetScan(&OnScan);

    if (nw%2 != 0) DRPerror("odd number of window limits");
  
    nw = nw/2;
    if (nw == 0) { 
	Window[0] = 0; 
	Window[1] = OnScan.NChannel-1; 
	nw = 1;
    } else {
	for (i=0; i<nw*2; i++) {
	    switch (xUnit) {
	      case VELOCITY: 
		Window[i] = VChannel(Range[i], &OnScan);
		break;
	      case FREQUENCY: 
		Window[i] = FChannel(Range[i], &OnScan);
		break;
	      case CHANNELS: 
		Window[i] = (int)Range[i]; 
		break;
	    }
	}
	for (i = 0; i < nw*2; i += 2) {
	    if (Window[i] > Window[i+1]) {
		l = Window[i];
		Window[i] = Window[i+1];
		Window[i+1] = l;
	    }
	}
    }
  
    DRPinfo("results:");
    for (i = 0; i < nw; i++) {
	sum = 0.0;
	start = Window[2*i]; 
	stop = Window[2*i+1];
/*
	printf("from %f to %f\n", 
	       Velocity(start, &OnScan), 
	       Velocity(stop, &OnScan));
	printf("from %f to %f\n", 
	       Velocity(start, &OnScan)-OnScan.VelRes/2, 
	       Velocity(stop, &OnScan) +OnScan.VelRes/2);
*/
	for (j = start; j <= stop; j++) sum += (double)OnScan.Channels[j];
	switch (xUnit) {
	  case VELOCITY: 
	    sum *= fabs(OnScan.VelRes);
	    printf (" area[%d] = %.3lf [K*km/s]\n", i+1, sum);
	    break;
	  case FREQUENCY: 
	    sum *= fabs(OnScan.FreqRes);
	    printf (" area[%d] = %.3lf [K*MHz]\n", i+1, sum);
	    break;
	  case CHANNELS: 
	    printf (" area[%d] = %.3lf [K*channel]\n", i+1, sum);
	    break;
	}
	area[i] = sum;
    }
  
    offx = OnScan.LMapOff*RADTOMIN;
    offy = OnScan.BMapOff*RADTOMIN;
    if ((lf = fopen("drp.log","a")) != NULL) {
	fprintf (lf, "AREA:\t%04d", OnScan.ScanNo);
	fprintf (lf, "\t%10.3f\t%10.3f", offx, offy);
	for (i = 0; i < nw; i++) fprintf (lf,"\t%10.3lf", area[i]);
	fprintf (lf,"\n");
    } else DRPerror("could not append to log file");

    exit(0);
}
