/* some useful constants */
#ifndef PI
#define PI 3.141592653589796       /* guess what?                */
#endif
#define LIGHTSPEED 2.997924562e8   /* c in meter per second      */
#define SECPERREV 1296000.0        /* arcsec per full circle     */
#define SECPERDAY 86400.0          /* seconds per day            */
#define ROTATE  1.00273790935      /* solar time/sidereal time   */
#define RPS ROTATE*PI/43200.0      /* rotation per sec. (radian) */

#include "vector.h"

void cuv(pVector * ,cVector );
void uvc(cVector ,pVector *);
void invert(rotMatrix );
void rotate(rotMatrix , cVector , cVector );
void trc(rotMatrix ,pVector * ,pVector *);
double djl(int ,int ,int );
void vmoon(double [] ,cVector );
void vearth(double ,double ,double ,double [] ,cVector );
void elements(double ,double []);
void nut(double ,rotMatrix );
void pre(double ,double ,rotMatrix );
double GMST(double );
double LMST(int ,int ,int ,double ,double ,double ,double *);
double JEpoch(double );
double BEpoch(double );
