#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
#define ZERO  0
#define MEAN  1
#define ABSOLUTE 2
int flag = ZERO;
int xUnit = VELOCITY;
double xMin = 0.0, xMax = 0.0;
float f;

char PROGRAM_NAME[] = "bad";
char description[] = "remove bad channels";
char required[] = "";
struct _options options[] = {
{ "-help",	 "Print out this message" },
{ "-zero",	 "set bad channel(s) to zero (default)" },
{ "-mean",	 "set bad channel(s) to mean of neighbouring channels" },
{ "-abs value",        "set bad channel(s) to an absolute value" },
{ "-vel v1 v2",		"select velocity range" },
{ "-freq f1 f2",	"select frequency range" },
{ "-chan c1 c2",	"select channel range" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "zero")) {
	flag = ZERO;
	return;
    }
    if (!strcmp(opt, "mean")) {
	flag = MEAN;
	return;
    }
    if (!strcmp(opt, "abs")) {
	flag = ABSOLUTE;
	GetOption(&optarg, pargc, pargv);
	f = atof(optarg);
	return;
    }
    if (!strcmp(opt, "vel")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	xUnit = VELOCITY;
	return;
    }
    if (!strcmp(opt, "freq")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	xUnit = FREQUENCY;
	return;
    }
    if (!strcmp(opt, "chan")) {
	GetOption(&optarg, pargc, pargv);
	xMin = (double)atoi(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = (double)atoi(optarg);
	xUnit = CHANNELS;
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main (int argc, char *argv[])
{
    int FirstCh = 0, LastCh = 0;
    int i;
    float chprev, chnext;
    float average;
  
    GetOpts(argc, argv);

    GetScan(&OnScan);
    if (xMin == 0.0 && xMax == 0.0) {
	FirstCh = 0;
	LastCh = OnScan.NChannel-1;
    } else {
	switch (xUnit) {
	  case VELOCITY:
	    FirstCh = VChannel(xMin, &OnScan);
	    LastCh  = VChannel(xMax, &OnScan);
	    break;
	  case FREQUENCY:
	    FirstCh = FChannel(xMin, &OnScan);
	    LastCh  = FChannel(xMax, &OnScan);
	    break;
	  case CHANNELS:
	    FirstCh = drpint(xMin);
	    LastCh  = drpint(xMax);
	    break;
	}
    }

    if (FirstCh > LastCh) {
	i = FirstCh;
	FirstCh = LastCh;
	LastCh = i;
    }

    if (FirstCh > 0) chprev = OnScan.Channels[FirstCh-1];
    else             chprev = 0.0;
    if (LastCh < OnScan.NChannel-1) chnext = OnScan.Channels[LastCh+1];
    else                            chnext = 0.0;
    average = (chprev+chnext)/2.0;
  
    for (i = FirstCh; i <= LastCh; i++) {
	if (flag == ZERO)  OnScan.Channels[i] = 0.0;
	else if (flag == MEAN) OnScan.Channels[i] = average;
        else OnScan.Channels[i] = f;
    }
  
    PutScan(&OnScan);
    exit(0);
}
