#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
#define MAXDIM   10
#define MAXRANGE 10
  
static double Range[MAXRANGE];
static int nw = 0;
static int order = 1;
static int xUnit = VELOCITY;

int solve(double **a, double *v, int n);

char PROGRAM_NAME[] = "baseline";
char description[] = "fit up to 9th order baseline over up to 5 regions";
char required[] = "";
struct _options options[] = {
{ "-help",		"Print out this message" },
{ "-vel v1 v2",		"select velocity range (up to 5)" },
{ "-freq f1 f2",	"select frequency range (up to 5)" },
{ "-chan c1 c2",	"select channel range (up to 5)" },
{ "-order n",           "specify order of baseline fit (default = 1)" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv) 
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "vel")) {
	if (nw == MAXRANGE) Syntax("-vel");
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	xUnit = VELOCITY;
	return;
    }
    if (!strcmp(opt, "freq")) {
	if (nw == MAXRANGE) Syntax("-chan");
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	xUnit = FREQUENCY;
	return;
    }
    if (!strcmp(opt, "chan")) {
	if (nw == MAXRANGE) Syntax("-chan");
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	Range[nw++] = atof(optarg);
	xUnit = CHANNELS;
	return;
    }
    if (!strcmp(opt, "order")) {
	GetOption(&optarg, pargc, pargv);
	order = atoi(optarg);
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main(int argc, char *argv[]) 
{
    double Polynom;
    double Matrix[MAXDIM*MAXDIM];
    double *Array[MAXDIM], Vector[MAXDIM], D[MAXDIM];
    double X,Y;
    static int Window[10], Dim;
    int i, j, l, w;
  
    GetOpts(argc, argv);

    if (nw%2 != 0) DRPerror("odd number of window limits");
  
    GetScan (&OnScan);
    nw = nw/2;
    if (nw == 0) { 
	Window[0] = 0; 
	Window[1] = OnScan.NChannel-1; 
	nw = 1;
    } else {
	for (i = 0; i < nw*2; i++) {
	    switch (xUnit) {
	      case VELOCITY: 
		Window[i] = VChannel(Range[i], &OnScan);
		break;
	      case FREQUENCY: 
		Window[i] = FChannel(Range[i], &OnScan);
		break;
	      case CHANNELS: 
		Window[i] = (int)Range[i]; 
		Window[i]--;
		break;
	    }
	}
	for (i = 0; i < nw*2; i += 2) {
	    if (Window[i] > Window[i+1]) {
		l = Window[i];
		Window[i] = Window[i+1];
		Window[i+1] = l;
	    }
	}
    }
  
    if (order < 1) order = 1;
    if (order >= MAXDIM) order = MAXDIM-1;
  
    Dim = order+1;
    for (i = 0; i < MAXDIM; i++) Array[i] = &Matrix[i*MAXDIM];
/*
    Array = (double **)calloc(Dim, sizeof(double *));
    if (Array == NULL) DRPerror("memory allocation failure");
    for (i = 0; i < Dim; i++) {
        Array[i] = (double *)calloc(Dim, sizeof(double));
        if (Array[i] == NULL) DRPerror("memory allocation failure");
    }
*/
    for (i = 0; i < Dim; i++) {
	Vector[i] = 0.0;
	for (j = i; j < Dim; j++) {
	    Array[i][j] = 0.0;
	    Array[j][i] = 0.0;
	}
    }
  
    for (w = 0; w < nw; w++) {
	for (i=Window[2*w]; i<=Window[2*w+1]; i++) {
	    X = (double)i/OnScan.NChannel;
	    Y = (double)OnScan.Channels[i];
	    D[0] = 1.0;
	    for (j = 1; j < Dim; j++) D[j] = D[j-1]*X;
	    for (j = 0; j < Dim; j++) {
		Vector[j] += Y*D[j];
		for (l = j; l < Dim; l++) {
		    Array[j][l] += D[j]*D[l];
		    Array[l][j] = Array[j][l];
		}
	    }
	}
    }
  
    if (solve(Array, Vector, Dim) == 0) DRPerror("singular matrix");
  
    DRPinfo("results:");
    for (i = 0; i < Dim; i++) {
	printf (" c[%d] = %e\n", i, Vector[i]);
	OnScan.work[i] = Vector[i];
    }
  
    for (i = 0; i < OnScan.NChannel; i++) {
	Polynom = Vector[Dim-1];
	X = (double)i/OnScan.NChannel;
	for (j=1; j<Dim; j++) Polynom = Polynom*X+Vector[Dim-j-1];
	OnScan.Channels[i] = (float)Polynom;
    }
  
    PutTemp (&OnScan);
    exit(0);
}
