#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
float bias = 0.0;

char PROGRAM_NAME[] = "bias";
char description[] = "add bias to spectrum";
char required[] = "value";
struct _options options[] = {
{ "-help",			"Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main (int argc, char *argv[])
{
    int i;
  
    GetOpts(argc, argv);
    if (argc <= 1) {
	Syntax("");
	exit(EX_ARGSBAD);
    } else {
	bias = atof(argv[1]);
    }

    GetScan (&OnScan);
  
    for (i=0; i<OnScan.NChannel; i++) {
	OnScan.Channels[i] += bias;
    }
  
    PutScan (&OnScan);
    exit(0);
}
