#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include "drp.h"
#include "plplot.h"
#include "options.h"

void plsfile(FILE *);

#define NO  0
#define YES 1

/* defaults */
float xMin = -1.0, xMax = 1.0;
float yMin = -1.0, yMax = 1.0;
int xlabel = YES;
int ylabel = YES;
int frame = YES;
int draft = YES;
int zeroline = NO;
int grid = NO;
int title = NO;
int viewport = NO;
char NewTitle[80];
char xLabel[80];
char yLabel[80];
float VxMin, VxMax, VyMin, VyMax;

char PROGRAM_NAME[] = "box";
char description[] = "draw a coordinate frame with given dimensions";
char required[] = "";
struct _options options[] = {
{ "-help",		"Print out this message" },
{ "-xrange x1 x2",	"select x range" },
{ "-yrange y1 y2",	"select y range" },
{ "-xlabel text",	"specify x label" },
{ "-ylabel text",	"specify y label" },
{ "-zero",		"draw y = 0.0 line" },
{ "-title text",        "specify title for plot" },
/* { "-noframe",           "don't draw coordinate frame" }, */
{ "-nodraft",		"use extended font for high quality labels" },
{ "-grid",              "draw grid at major tick intervals" },
{ "-view",              "specify viewport" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(EX_SUCCESS);
    }
    if (!strcmp(opt, "xrange")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	return;
    }
    if (!strcmp(opt, "yrange")) {
	GetOption(&optarg, pargc, pargv);
	yMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	yMax = atof(optarg);
	return;
    }
    if (!strcmp(opt, "zero")) {
	zeroline = YES;
	return;
    }
    if (!strcmp(opt, "title")) {
	title = YES;
	GetOption(&optarg, pargc, pargv);
	strcpy(NewTitle, optarg);
	return;
    }
    if (!strcmp(opt, "xlabel")) {
	xlabel = YES;
	GetOption(&optarg, pargc, pargv);
	strcpy(xLabel, optarg);
	return;
    }
    if (!strcmp(opt, "ylabel")) {
	ylabel = YES;
	GetOption(&optarg, pargc, pargv);
	strcpy(yLabel, optarg);
	return;
    }
/*    if (!strcmp(opt, "noframe")) {
	frame = NO;
	return;
    } */
    if (!strcmp(opt, "nodraft")) {
	draft = NO;
	return;
    }
    if (!strcmp(opt, "grid")) {
	grid = YES;
	return;
    }
    if (!strcmp(opt, "view")) {
	viewport = YES;
	GetOption(&optarg, pargc, pargv);
	VxMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	VxMax = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	VyMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	VyMax = atof(optarg);
	return;
    }
    Syntax(**pargv);
}

int main (int argc, char *argv[])
{
    FILE *meta;
    int id;
    static char metaname[MAXNAMLEN+1];
    float scale;
    float xarray[2], yarray[2];
     
    GetOpts(argc, argv);

/*
    if (xMin > xMax) {	swap = xMin;	xMin = xMax;	xMax = swap;    }
    if (yMin > yMax) {	swap = yMin;	yMin = yMax;	yMax = swap;    }
*/

    if ((id = fork()) == 0) {
	strcpy(metaname, getenv("HOME"));
	strcat(metaname, METAFILE);
	meta = fopen(metaname, "w");
	if (meta == NULL) DRPerror("can't open metacode file");

	plsfile(meta);
	plstart("plmeta", 1, 1); 
    } else {
	plstart(PLDEVICE, 1, 1); 
	plclr();
    }

    if (!draft) {
	plfontld(1);
	plfont(2);
	plwid(4);
    }

    pladv(0);
    if (viewport) {
	plvpor((PLFLT)VxMin, (PLFLT)VxMax, (PLFLT)VyMin, (PLFLT)VyMax);
	scale = VyMax-VyMin;
	plsmaj(0.0, scale);
	plsmin(0.0, scale);
	plschr(0.0, scale);
    } else plvsta();

    plwind((PLFLT)xMin, (PLFLT)xMax, (PLFLT)yMin, (PLFLT)yMax);
    if (frame) {
	if (grid) plbox("abcgnst", (PLFLT)0.0, 0, "abcgnstv", (PLFLT)0.0, 0);
	else      plbox("bcnst", (PLFLT)0.0, 0, "bcnstv", (PLFLT)0.0, 0);
    } else {
	plbox("at", (PLFLT)0.0, 0, "at", (PLFLT)0.0, 0);
    }	
    if (zeroline) {
	if (yMin < 0.0 && yMax > 0.0) {
	    xarray[0] = xMin;
	    xarray[1] = xMax;
	    yarray[0] = 0.0;
	    yarray[1] = 0.0;
	}
	plline(2, xarray, yarray);
    }
    pllab(xLabel, yLabel, NewTitle);
/*    plmtex ("t", (PLFLT)2.0, (PLFLT)0.5, (PLFLT)0.5, NewTitle);  */

    plend();
    if (id == 0) fclose(meta);

    exit (EX_SUCCESS);
}
