#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
static char scanname[MAXNAMLEN+1] = "";

char PROGRAM_NAME[] = "byteswap";
char description[] = "change byte gender of all data";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-file filename",             "specify full filename" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "file")) {
	GetOption(&optarg, pargc, pargv);
	strcpy(scanname, optarg);
	return;
    }
    Syntax(**pargv);
}

#define READ 0

SCAN OnScan;

void swapbytes(char *p, int n)
{
    char swap;
    int i;

    for (i = 0; i < n/2; i++) {
	swap = p[i];
	p[i] = p[n-1-i];
	p[n-1-i] = swap;
    }
}
    
int main (int argc, char *argv[])
{
    FILE *scan;
    int i, n;

    GetOpts(argc, argv);

    if (scanname[0] == '\0') {
	if (argv[1] == NULL) {
	    Syntax("");
	    exit(EX_ARGSBAD);
	} else {
	    strcpy(scanname, argv[1]);
	}
    }

    scan = fopen (scanname,"r");
    if (scan == NULL) DRPerror("can't open file '%s'", scanname);

    n = fread ((char *)&OnScan, 1, HEADER , scan);
    if (n != HEADER) DRPerror("error reading header record");

    swapbytes((char *)&OnScan.Version, sizeof(short));
    swapbytes((char *)&OnScan.NChannel, sizeof(short));
    swapbytes((char *)&OnScan.Ctrl, sizeof(short));
    swapbytes((char *)&OnScan.ScanNo, sizeof(short));
    swapbytes((char *)&OnScan.SubScan, sizeof(short));
    swapbytes((char *)&OnScan.Year, sizeof(short));
    swapbytes((char *)&OnScan.Month, sizeof(short));
    swapbytes((char *)&OnScan.Day, sizeof(short));
    swapbytes((char *)&OnScan.UTHour, sizeof(short));
    swapbytes((char *)&OnScan.UTMin, sizeof(short));
    swapbytes((char *)&OnScan.UTSec, sizeof(short));
    swapbytes((char *)&OnScan.STHour, sizeof(short));
    swapbytes((char *)&OnScan.STMin, sizeof(short));
    swapbytes((char *)&OnScan.STSec, sizeof(short));
    swapbytes((char *)&OnScan.CSystem, sizeof(short));
    swapbytes((char *)&OnScan.ObsMode, sizeof(short));
    swapbytes((char *)&OnScan.Backend, sizeof(short));
    swapbytes((char *)&OnScan.Frontend, sizeof(short));

    swapbytes((char *)&OnScan.MapX, sizeof(short));
    swapbytes((char *)&OnScan.MapY, sizeof(short));

    swapbytes((char *)&OnScan.JulDate, sizeof(long));

    swapbytes((char *)&OnScan.AirTemp, sizeof(float));
    swapbytes((char *)&OnScan.Pressure, sizeof(float));
    swapbytes((char *)&OnScan.Humidity, sizeof(float));
    swapbytes((char *)&OnScan.Equinox, sizeof(float));
    swapbytes((char *)&OnScan.EquiNow, sizeof(float));
    swapbytes((char *)&OnScan.Longitude, sizeof(float));
    swapbytes((char *)&OnScan.Latitude, sizeof(float));
    swapbytes((char *)&OnScan.Long2000, sizeof(float));
    swapbytes((char *)&OnScan.Lat2000, sizeof(float));
    swapbytes((char *)&OnScan.LMapOff, sizeof(float));
    swapbytes((char *)&OnScan.BMapOff, sizeof(float));
    swapbytes((char *)&OnScan.Azimuth, sizeof(float));
    swapbytes((char *)&OnScan.Elevation, sizeof(float));
    swapbytes((char *)&OnScan.AzOffset, sizeof(float));
    swapbytes((char *)&OnScan.ElOffset, sizeof(float));
    swapbytes((char *)&OnScan.AzMapOff, sizeof(float));
    swapbytes((char *)&OnScan.ElMapOff, sizeof(float));
    swapbytes((char *)&OnScan.AzPointg, sizeof(float));
    swapbytes((char *)&OnScan.ElPointg, sizeof(float));
    swapbytes((char *)&OnScan.AzErrAve, sizeof(float));
    swapbytes((char *)&OnScan.ElErrAve, sizeof(float));
    swapbytes((char *)&OnScan.AzErrRms, sizeof(float));
    swapbytes((char *)&OnScan.ElErrRms, sizeof(float));
    swapbytes((char *)&OnScan.GalLong, sizeof(float));
    swapbytes((char *)&OnScan.GalLat, sizeof(float));
    swapbytes((char *)&OnScan.VHel, sizeof(float));
    swapbytes((char *)&OnScan.VLsr, sizeof(float));
    swapbytes((char *)&OnScan.Axial, sizeof(float));
    swapbytes((char *)&OnScan.Shift, sizeof(float));
    swapbytes((char *)&OnScan.VTilt, sizeof(float));
    swapbytes((char *)&OnScan.HTilt, sizeof(float));
    swapbytes((char *)&OnScan.Tcal, sizeof(float));
    swapbytes((char *)&OnScan.Tsys, sizeof(float));
    swapbytes((char *)&OnScan.Trec, sizeof(float));
    swapbytes((char *)&OnScan.Tau, sizeof(float));
    swapbytes((char *)&OnScan.dBl, sizeof(float));
    swapbytes((char *)&OnScan.IntTime, sizeof(float));
    swapbytes((char *)&OnScan.RefCorr, sizeof(float));
    swapbytes((char *)&OnScan.ParAngle, sizeof(float));
    swapbytes((char *)&OnScan.PosAngle, sizeof(float));
    swapbytes((char *)&OnScan.StepX, sizeof(float));
    swapbytes((char *)&OnScan.StepY, sizeof(float));

    swapbytes((char *)&OnScan.Bandwidth, sizeof(double));
    swapbytes((char *)&OnScan.RestFreq, sizeof(double));
    swapbytes((char *)&OnScan.SkyFreq, sizeof(double));
    swapbytes((char *)&OnScan.FirstIF, sizeof(double));
    swapbytes((char *)&OnScan.FreqThrow, sizeof(double));
    swapbytes((char *)&OnScan.FreqRes, sizeof(double));
    swapbytes((char *)&OnScan.VSource, sizeof(double));
    swapbytes((char *)&OnScan.VelRes, sizeof(double));

    for (i = 0; i < 10; i++) 
      swapbytes((char *)&OnScan.work[i], sizeof(float));

    for (i = 0; i < 31; i++) 
      swapbytes((char *)&OnScan.flag[i], sizeof(short));

    n = fread ((char *)OnScan.Channels, sizeof(float), OnScan.NChannel, scan);
    if (n != OnScan.NChannel) DRPerror("error reading data record");

    for (i = 0; i < MAXCHANNELS; i++) 
      swapbytes((char *)&OnScan.Channels[i], sizeof(float));

    PutScan (&OnScan);
    fclose(scan);
    exit(0);
}

