#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"

char PROGRAM_NAME[] = "calc";
char description[] = "combine this scan with temp area";
char required[] = "";
struct _options options[] = {
{ "-add",			"add the two scans: work+temp " },
{ "-subtract",			"subtract the two scans: work-temp" },
{ "-multiply",			"multiply the two scans: work*temp" },
{ "-divide",			"divide the two scans: work/temp" },
{ "-help",			"Print out this message" },
{NULL, NULL }};

#define ADD 0
#define SUB 1
#define MUL 2
#define DIV 3
#define CAL 4

static int oper = ADD;

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "add")) {
	oper = ADD;
	return;
    }
    if (!strcmp(opt, "subtract")) {
	oper = SUB;
	return;
    }
    if (!strcmp(opt, "multiply")) {
	oper = MUL;
	return;
    }
    if (!strcmp(opt, "divide")) {
	oper = DIV;
	return;
    }
    if (!strcmp(opt, "cal")) {
	oper = CAL;
	return;
    }
    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    Syntax(**pargv);
}

SCAN OnScan, temp;
  
int main(int argc, char *argv[])
{
  int i;

  GetOpts(argc, argv);

  GetScan(&OnScan);
  GetTemp(&temp);

  if (OnScan.NChannel != temp.NChannel) 
    DRPerror("number of channel mismatch");

  for (i=0; i<OnScan.NChannel; i++) {
    switch (oper) {
     case ADD:
      OnScan.Channels[i] += temp.Channels[i];
      break;
     case SUB:
      OnScan.Channels[i] -= temp.Channels[i];
      break;
     case MUL:
      OnScan.Channels[i] *= temp.Channels[i];
      break;
     case DIV:
      if (temp.Channels[i] != 0.0) {
	OnScan.Channels[i] /= temp.Channels[i];
      } else OnScan.Channels[i] = 0.0;
      break;
     case CAL:
      if (temp.Channels[i] != 0.0) {
	OnScan.Channels[i] = 
	  (OnScan.Channels[i]/OnScan.IntTime - temp.Channels[i]/temp.IntTime)
	  / (temp.Channels[i]/temp.IntTime);
      } else OnScan.Channels[i] = 0.0;
      break;
    }
  }

  PutScan(&OnScan);
  
  exit(0);
}
