#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "drp.h"
#include "options.h"
  
double radian();
  
char PROGRAM_NAME[] = "centre";
char description[] = "recentre scan on given source position";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main (int argc, char *argv[])
{
    float CentreX, CentreY;
  
    GetOpts(argc, argv);

    if (argc < 3) DRPerror("new position required argument");

    CentreX = radian(argv[1]);
    CentreY = radian(argv[2]);

#ifdef DEBUG
    printf ("new centre position: %s %s (%f %f)\n", 
	    argv[1], argv[2], CentreX, CentreY);
#endif

    GetScan (&OnScan);
    OnScan.LMapOff += (OnScan.Longitude-CentreX)*cos((double)CentreY);
    OnScan.BMapOff += (OnScan.Latitude-CentreY);
    OnScan.Longitude = CentreX;
    OnScan.Latitude = CentreY;
    PutScan (&OnScan);
    OnScan.LMapOff *= RADTOMIN;
    OnScan.BMapOff *= RADTOMIN;
    DRPinfo("new offsets: %.3f %.3f", OnScan.LMapOff, OnScan.BMapOff);
  
    exit(0);
}
