#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
static float yMin = -1.0e10;
static float yMax =  1.0e10;
  
char PROGRAM_NAME[] = "clip";
char description[] = "";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-min minimum",               "specify minimum channel value" },
{ "-max maximum",               "specify maximum channel value" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "min")) {
	GetOption(&optarg, pargc, pargv);
	yMin = atof(optarg);
	return;
    }
    if (!strcmp(opt, "max")) {
	GetOption(&optarg, pargc, pargv);
	yMax = atof(optarg);
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main(int argc, char *argv[])
{
    int i;
  
    GetOpts(argc, argv);
    GetScan(&OnScan);
  
    for (i=0; i<OnScan.NChannel; i++) {
	if (OnScan.Channels[i] > yMax) OnScan.Channels[i] = yMax;
	if (OnScan.Channels[i] < yMin) OnScan.Channels[i] = yMin;
    }
  
    PutScan (&OnScan);
    exit(0);
}
