/* CONVERT, convert channels to/from velocity and frequency */
  
/*
 * note:
 *
 * channel numbers in these routines will be one less than
 * corresponding numbers in FORTRAN, because a spectrum of
 * length n is numbered from 0..n-1 rather than 1..n
 *
 */
 
#include <math.h>
#include "drp.h"

void range (double from, double to, int unit, int *beg, int *end, SCAN *Scan);

int drpint(double x)
{
   double d;

   d = (fabs(floor(x)-x) < fabs(ceil(x)-x) ? floor(x) : ceil(x) );
   return (int)d;
}

int CenterCh(SCAN *Scan)
{
   return (Scan->NChannel/2);
}
  
double Velocity (int ch, SCAN *Scan)
{
   double Vel;

   if (ch < 0)                ch = 0;
   if (ch > Scan->NChannel-1) ch = Scan->NChannel-1;
   Vel = (double)(ch-CenterCh(Scan))*Scan->VelRes+Scan->VSource;
   return (Vel);
}
  
double Frequency (int ch, SCAN *Scan)
{
   double Freq;
  
   if (ch < 0)                ch = 0;
   if (ch > Scan->NChannel-1) ch = Scan->NChannel-1;
   Freq = (double)(ch-CenterCh(Scan))*Scan->FreqRes+Scan->RestFreq;
   return (Freq);
}
  
int FChannel (double freq, SCAN *Scan)
{
   int ch;
  
   ch = CenterCh(Scan)+drpint((freq-Scan->RestFreq)/Scan->FreqRes);
   if (ch < 0) ch = 0;
   if (ch > Scan->NChannel-1) ch = Scan->NChannel-1;
   return (ch);
}
  
int VChannel (double vel, SCAN *Scan)
{
   int ch;
  
   ch = CenterCh(Scan)+drpint((vel-Scan->VSource)/Scan->VelRes);
   if (ch < 0) ch = 0;
   if (ch > Scan->NChannel-1) ch = Scan->NChannel-1;
   return (ch);
}

void range (double from, double to, int unit, int *beg, int *end, SCAN *Scan)
{
   int swap;
   
   switch (unit) {
      case VELOCITY:
         *beg = VChannel(from,Scan);
         *end = VChannel(to,Scan);
         break;
      case FREQUENCY:
         *beg = FChannel(from,Scan);
         *end = FChannel(to,Scan);
	 break;
      case CHANNELS:  
         *beg = drpint(from);
         *end = drpint(to);
	 (*beg)--; (*end)--;
	 break;
   }
   if (*end < *beg) {
      swap = *beg;
      *beg = *end;
      *end = swap;
   }
}
