#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "drp.h"
#include "options.h"

char PROGRAM_NAME[] = "convolve";
char description[] = "convolve work area with temporary area";
char required[] = "";
struct _options options[] = {
{ "-help",		   "Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    Syntax(**pargv);
}

void realft(float [], int, int);

SCAN OnScan;
SCAN Response;
  
int main(int argc, char *argv[])
{
    float Re, Im;
    int i, ii, n;
  
    GetOpts(argc, argv);

    GetScan(&OnScan);
    GetTemp(&Response);
  
    n = 2;
    while (n < OnScan.NChannel) n *= 2;

    for (i = OnScan.NChannel; i < n; i++) {
	OnScan.Channels[i] = Response.Channels[i] = 0.0;
    }

    /* Fourier transform both arrays */
    realft(OnScan.Channels, n/2, 1);
    realft(Response.Channels, n/2, 1);

    /* (complex) multiply arrays */
    for (i = 1; i < n/2; i++) {
	ii = 2*i;
	Re = OnScan.Channels[ii]*Response.Channels[ii]
	  - OnScan.Channels[ii+1]*Response.Channels[ii+1];
	Im = OnScan.Channels[ii+1]*Response.Channels[ii]
	  + OnScan.Channels[ii]*Response.Channels[ii+1];
	OnScan.Channels[ii] = Re; OnScan.Channels[ii+1] = Im;
    }

    OnScan.Channels[0] = OnScan.Channels[0]*Response.Channels[0];
    OnScan.Channels[1] = OnScan.Channels[1]*Response.Channels[1];

    /* do inverse transform */
    realft(OnScan.Channels, n/2, -1);
  
    PutScan(&OnScan);
  
    exit(0);
}
