#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "drp.h"
#include "options.h"

char PROGRAM_NAME[] = "correlate";
char description[] = "correlate work area with temporary area";
char required[] = "";
struct _options options[] = {
{ "-help",		   "Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    Syntax(**pargv);
}

void realft(float [], int, int);

SCAN OnScan;
SCAN LagScan;
  
int main(int argc, char *argv[])
{
    float Re, Im;
    int i, n;
  
    GetScan (&OnScan);
    GetTemp (&LagScan);
  
    n = 2;
    while (n < OnScan.NChannel) n *= 2;

    for (i = OnScan.NChannel; i < n; i++) {
	OnScan.Channels[i] = LagScan.Channels[i] = 0.0;
    }

    /* Fourier transform both arrays */
    realft(OnScan.Channels, n/2, 1);
    realft(LagScan.Channels, n/2, 1);

    /* (complex) multiply arrays */
    for (i = 1; i < n/2; i++) {
	Re = OnScan.Channels[2*i]*LagScan.Channels[2*i]
	  + OnScan.Channels[2*i+1]*LagScan.Channels[2*i+1];
	Im = OnScan.Channels[2*i+1]*LagScan.Channels[2*i]
	  - OnScan.Channels[2*i]*LagScan.Channels[2*i+1];
	OnScan.Channels[2*i] = Re; OnScan.Channels[2*i+1] = Im;
    }

    OnScan.Channels[0] = OnScan.Channels[0]*LagScan.Channels[0];
    OnScan.Channels[1] = OnScan.Channels[1]*LagScan.Channels[1];

    /* do inverse transform */
    realft(OnScan.Channels, n/2,-1);
  
    PutScan(&OnScan);
  
    exit(0);
}
