#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"

int columns = 8;
int xUnit = CHANNELS;
float xMin = 0.0, xMax = 0.0;

char PROGRAM_NAME[] = "data";
char description[] = "produce listing of channel values";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-vel v1 v2",		"select velocity range" },
{ "-freq f1 f2",	"select frequency range" },
{ "-chan c1 c2",	"select channel range" },
{ "-column n",	        "select number of columns for output" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(EX_SUCCESS);
    }
    if (!strcmp(opt, "vel")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	xUnit = VELOCITY;
	return;
    }
    if (!strcmp(opt, "freq")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	xUnit = FREQUENCY;
	return;
    }
    if (!strcmp(opt, "chan")) {
	GetOption(&optarg, pargc, pargv);
	xMin = (double)atoi(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = (double)atoi(optarg);
	xUnit = CHANNELS;
	return;
    }
    if (!strcmp(opt, "column")) {
	GetOption(&optarg, pargc, pargv);
	columns = atoi(optarg);
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main (int argc, char *argv[])
{
   int FirstCh = 0, LastCh = 0;
   int i, col;

   GetOpts(argc, argv);
   GetScan (&OnScan);

   columns /= 2;
   if (columns < 1) columns = 1;

   if (xMin == 0.0 && xMax == 0.0) {
       FirstCh = 0;
       LastCh = OnScan.NChannel-1;
   } else {
       switch (xUnit) {
	 case VELOCITY:
	   FirstCh = VChannel((double)xMin, &OnScan);
	   LastCh  = VChannel((double)xMax, &OnScan);
	   break;
	 case FREQUENCY:
	   FirstCh = FChannel((double)xMin, &OnScan);
	   LastCh  = FChannel((double)xMax, &OnScan);
	   break;
	 case CHANNELS:
	   FirstCh = (int)xMin;
	   LastCh  = (int)xMax;
	   break;
       }
   }

   if (FirstCh > LastCh) {
      i = FirstCh;
      FirstCh = LastCh;
      LastCh = i;
   }

   DRPinfo("listing channel contents:");
   col=0;
   for (i = FirstCh; i <= LastCh; i++) {
       switch (xUnit) {
	 case VELOCITY:
	   printf("%8.2lf", Velocity(i, &OnScan));
	   break;
	 case FREQUENCY:
	   printf("%8.1lf", Frequency(i, &OnScan));
	   break;
	 case CHANNELS:
	   printf("%5d", i);
	   break;
       }
       printf ("%8.3f", OnScan.Channels[i]);
       col++; 
       if (!(col%columns)) printf("\n");
       else                printf(" "); 
   }
   printf("\n");
   exit(EX_SUCCESS);
}
