#include <stdio.h>
#include <string.h>
#include "drp.h"

#define DFWORD short int
#define DFILBLOCK 1024

/* open a dfil, given dfil number, block length and user */
FILE *OpenDfil(int dfil,int blocklen,char *user,char *dfilname)
{
    int unit, id;
    FILE *df;

    unit = dfil/100;
    id   = dfil%100;
    if (blocklen == 3) blocklen = 0;

    switch (unit) {
      case 8:
	sprintf(dfilname,"/scr/ANT8/DF%02d%04d.%s",id,blocklen,user);
	break;
      case 9:
	sprintf(dfilname,"/tmp/ANT9/DF%02d%04d.%s",id,blocklen,user);
	break;
      default:
	sprintf(dfilname,"/ANT%1d/DF%02d%04d.%s", unit,id,blocklen,user);
	break;
    }
    df = fopen(dfilname,"r+");
    if (df == NULL) DRPerror("can't open file '%s'", dfilname);
    return (df);
}

/* read the block index of dfil */
void ReadDfilIndex(FILE *df,DFWORD index[])
{
    int nw, rw;

    rw = fseek(df, 0L, 0);
    if (rw == -1) DRPerror("can't position to beginning of file");
    if ((nw = fread((char *)index, sizeof(DFWORD), DFILBLOCK, df)) == 0) 
      DRPerror("can't read index");
}

/* write the block index of dfil */
void WriteDfilIndex(FILE *df,DFWORD index[])
{
    int nw, rw;

    rw = fseek(df, 0L, 0);
    if (rw == -1) DRPerror("can't position to beginning of file");
    nw = fwrite((char *)index, sizeof(DFWORD), DFILBLOCK, df);
    if (nw == 0) DRPerror("can't write index");
}

/* find block in dfil, 1 <= block <= DFILBLOCK */
void GetDfilBlock(FILE *df,int block,int blocklen,DFWORD itwh[])
{
    long where;
    int rw, b;
    DFWORD *wp;
   
    where = (long)((block-1)*blocklen+1)*DFILBLOCK*sizeof(DFWORD);
    rw = fseek(df, where, 0);
    if (rw == -1) DRPerror("can't position to block %ld", where);
    for (b=0, wp=itwh; b<blocklen; b++, wp+=DFILBLOCK) {
	if (fread((char *)wp, sizeof(DFWORD), DFILBLOCK, df) == 0) 
	  DRPerror("can't read block %d (%ld)", b, where);
    }
}

/* write block in dfil, 1 <= block <= DFILBLOCK */
void PutDfilBlock(FILE *df,int block,int blocklen,DFWORD itwh[])
{
    long where;
    int rw, b;
    DFWORD *wp;
   
    where = (long)((block-1)*blocklen+1)*DFILBLOCK*sizeof(DFWORD);
    rw = fseek(df, where, 0);
    if (rw == -1) DRPerror("can't position to block %ld", where);
    for (b=0, wp=itwh; b<blocklen; b++, wp+=DFILBLOCK) {
	if (fwrite((char *)wp, sizeof(DFWORD), DFILBLOCK, df) == 0) 
	  DRPerror("can't write block %d (%ld)", b, where);
    }
}

/* look up block number for given scan number */
int FindDfilScan(DFWORD scanno,DFWORD index[])
{
    int i;

    for (i=0; i<DFILBLOCK; i++) {
	if (scanno == index[i]) break;
    }
    return (i==DFILBLOCK ? 0 : i+1);
}
