#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"

int xUnit = VELOCITY;
float xMin = 0.0, xMax = 0.0;

int VChannel(double , SCAN *);
int FChannel(double , SCAN *);

char PROGRAM_NAME[] = "drop";
char description[] = "drop channels (permanently!) outside given region";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-vel v1 v2",		"select velocity range to keep" },
{ "-freq f1 f2",	"select frequency range to keep" },
{ "-chan c1 c2",	"select channel range to keep" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "vel")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	xUnit = VELOCITY;
	return;
    }
    if (!strcmp(opt, "freq")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	xUnit = FREQUENCY;
	return;
    }
    if (!strcmp(opt, "chan")) {
	GetOption(&optarg, pargc, pargv);
	xMin = (double)atoi(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = (double)atoi(optarg);
	xUnit = CHANNELS;
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main (int argc, char *argv[])
{
    int FirstCh = 0, LastCh = 0;
    int i, n, shift;

    GetOpts(argc, argv);

    GetScan (&OnScan);
    if (xMin == 0.0 && xMax == 0.0) {
	FirstCh = 0;
	LastCh = OnScan.NChannel-1;
    } else {
	switch (xUnit) {
	  case VELOCITY:
	    FirstCh = VChannel((double)xMin, &OnScan);
	    LastCh  = VChannel((double)xMax, &OnScan);
	    break;
	  case FREQUENCY:
	    FirstCh = FChannel((double)xMin, &OnScan);
	    LastCh  = FChannel((double)xMax, &OnScan);
	    break;
	  case CHANNELS:
	    FirstCh = (int)xMin;
	    LastCh  = (int)xMax;
	    break;
	}
    }

    if (FirstCh > LastCh) {
	i = FirstCh;
	FirstCh = LastCh;
	LastCh = i;
    }

    for (i = FirstCh, n = 0; i <= LastCh; i++, n++) {
	OnScan.Channels[n] = OnScan.Channels[i];
    }
  
    shift = FirstCh+LastCh+1-OnScan.NChannel;
  
    OnScan.NChannel = n;
    OnScan.SkyFreq += (double)shift*OnScan.FreqRes/2.0;
    OnScan.RestFreq += (double)shift*OnScan.FreqRes/2.0;
    OnScan.VSource += (double)shift*OnScan.VelRes/2.0;
    OnScan.Bandwidth = OnScan.FreqRes*OnScan.NChannel;
  
    PutScan (&OnScan);
    exit(0);
}
