#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"

int work = 0;
int data = 0;
int size = 0;

char PROGRAM_NAME[] = "dump";
char description[] = "dump scan contents";
char required[] = "";
struct _options options[] = {
{ "-work",		"include internal work areas in dump" },
{ "-data",		"include data in dump" },
{ "-size",		"include structure size in dump" },
{ "-help",		"Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt; /* , *optarg; */

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "work")) {
	work = 1;
	return;
    }
    if (!strcmp(opt, "data")) {
	data = 1;
	return;
    }
    if (!strcmp(opt, "size")) {
	size = 1;
	return;
    }

    Syntax(**pargv);
}

SCAN OnScan;

int main(int argc, char *argv[])    
{
    int i;

    GetOpts(argc, argv);
    GetScan(&OnScan);
    
    if (size) {
	printf("size of struct scan = %lu\n", SCANLEN);
	printf("size of header      = %lu\n\n", HEADER);
    }

    printf("OnScan.Version = %hx\n",  OnScan.Version);
    printf("OnScan.NChannel= %d\n",   OnScan.NChannel);
    printf("OnScan.Ctrl    = %d\n",   OnScan.Ctrl   );
    printf("OnScan.ScanNo  = %d\n",   OnScan.ScanNo );
    printf("OnScan.SubScan = %d\n",   OnScan.SubScan);
    printf("OnScan.Year    = %d\n",   OnScan.Year   );
    printf("OnScan.Month   = %d\n",   OnScan.Month  );
    printf("OnScan.Day     = %d\n",   OnScan.Day    );
    printf("OnScan.UTHour  = %d\n",   OnScan.UTHour );
    printf("OnScan.UTMin   = %d\n",   OnScan.UTMin  );
    printf("OnScan.UTSec   = %d\n",   OnScan.UTSec  );
    printf("OnScan.STHour  = %d\n",   OnScan.STHour );
    printf("OnScan.STMin   = %d\n",   OnScan.STMin  );
    printf("OnScan.STSec   = %d\n",   OnScan.STSec  );
    printf("OnScan.CSystem = %d\n",   OnScan.CSystem);
    printf("OnScan.ObsMode = %d\n",   OnScan.ObsMode);
    printf("OnScan.Backend = %d\n",   OnScan.Backend);
    printf("OnScan.Frontend= %d\n",   OnScan.Frontend);
    printf("OnScan.MapX    = %d\n",   OnScan.MapX   );
    printf("OnScan.MapY    = %d\n",   OnScan.MapY   );

    printf("OnScan.JulDate  = %d\n",   OnScan.JulDate);

    printf("OnScan.Name     = '%.12s'\n", OnScan.Name);
    printf("OnScan.Project  = '%.4s'\n",  OnScan.Project);
    printf("OnScan.Observer = '%.16s'\n", OnScan.Observer);
    printf("OnScan.Program  = '%.16s'\n", OnScan.Program);
    printf("OnScan.Molecule = '%.18s'\n", OnScan.Molecule);

    printf("OnScan.AirTemp   = %f\n",   OnScan.AirTemp   );
    printf("OnScan.Pressure  = %f\n",   OnScan.Pressure  );
    printf("OnScan.Humidity  = %f\n",   OnScan.Humidity  );
    printf("OnScan.Equinox   = %f\n",   OnScan.Equinox   );
    printf("OnScan.EquiNow   = %f\n",   OnScan.EquiNow   );
    printf("OnScan.Longitude = %f\n",   OnScan.Longitude );
    printf("OnScan.Latitude  = %f\n",   OnScan.Latitude  );
    printf("OnScan.Long2000  = %f\n",   OnScan.Long2000  );
    printf("OnScan.Lat2000   = %f\n",   OnScan.Lat2000   );
    printf("OnScan.LMapOff   = %f\n",   OnScan.LMapOff   );
    printf("OnScan.BMapOff   = %f\n",   OnScan.BMapOff   );
    printf("OnScan.Azimuth   = %f\n",   OnScan.Azimuth   );
    printf("OnScan.Elevation = %f\n",   OnScan.Elevation );
    printf("OnScan.AzOffset  = %f\n",   OnScan.AzOffset  );
    printf("OnScan.ElOffset  = %f\n",   OnScan.ElOffset  );
    printf("OnScan.AzMapOff  = %f\n",   OnScan.AzMapOff  );
    printf("OnScan.ElMapOff  = %f\n",   OnScan.ElMapOff  );
    printf("OnScan.AzPointg  = %f\n",   OnScan.AzPointg  );
    printf("OnScan.ElPointg  = %f\n",   OnScan.ElPointg  );
    printf("OnScan.AzErrAve  = %f\n",   OnScan.AzErrAve  );
    printf("OnScan.ElErrAve  = %f\n",   OnScan.ElErrAve  );
    printf("OnScan.AzErrRms  = %f\n",   OnScan.AzErrRms  );
    printf("OnScan.ElErrRms  = %f\n",   OnScan.ElErrRms  );
    printf("OnScan.GalLong   = %f\n",   OnScan.GalLong   );
    printf("OnScan.GalLat    = %f\n",   OnScan.GalLat    );
    printf("OnScan.VHel      = %f\n",   OnScan.VHel      );
    printf("OnScan.VLsr      = %f\n",   OnScan.VLsr      );
    printf("OnScan.Axial     = %f\n",   OnScan.Axial     );
    printf("OnScan.Shift     = %f\n",   OnScan.Shift     );
    printf("OnScan.VTilt     = %f\n",   OnScan.VTilt     );
    printf("OnScan.HTilt     = %f\n",   OnScan.HTilt     );
    printf("OnScan.Tcal      = %f\n",   OnScan.Tcal      );
    printf("OnScan.Tsys      = %f\n",   OnScan.Tsys      );
    printf("OnScan.Trec      = %f\n",   OnScan.Trec      );
    printf("OnScan.Tau       = %f\n",   OnScan.Tau       );
    printf("OnScan.dBl       = %f\n",   OnScan.dBl       );
    printf("OnScan.IntTime   = %f\n",   OnScan.IntTime   );
    printf("OnScan.RefCorr   = %f\n",   OnScan.RefCorr   );
    printf("OnScan.ParAngle  = %f\n",   OnScan.ParAngle  );
    printf("OnScan.PosAngle  = %f\n",   OnScan.PosAngle  );
    printf("OnScan.StepX     = %f\n",   OnScan.StepX     );
    printf("OnScan.StepY     = %f\n",   OnScan.StepY     );

    printf("OnScan.Bandwidth = %lf\n",OnScan.Bandwidth );
    printf("OnScan.RestFreq  = %lf\n",OnScan.RestFreq  );
    printf("OnScan.SkyFreq   = %lf\n",OnScan.SkyFreq   );
    printf("OnScan.FirstIF   = %lf\n",OnScan.FirstIF   );
    printf("OnScan.FreqThrow = %lf\n",OnScan.FreqThrow );
    printf("OnScan.FreqRes   = %lf\n",OnScan.FreqRes   );
    printf("OnScan.VSource   = %lf\n",OnScan.VSource   );
    printf("OnScan.VelRes    = %lf\n",OnScan.VelRes    );

    if (work) {
	for (i = 0; i < 10; i++)     
	  printf("OnScan.work[%2d]  = %f\n", i, OnScan.work[i]);
	for (i = 0; i < 31; i++)     
	  printf("OnScan.flag[%2d]  = %d\n", i, OnScan.flag[i]);
    }

    if (data) {
	for (i = 0; i < OnScan.NChannel; i++)     
	  printf("OnScan.data[%04d]  = %f\n", i, OnScan.Channels[i]);
    }
    exit(0);
}
