#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

extern char PROGRAM_NAME[];

void DRPerror(char *fmt, ...)
{
    va_list args;

    va_start(args, fmt);
    fprintf(stderr, "%s -- exiting: ", PROGRAM_NAME);
    vfprintf(stderr, fmt, args);
    fprintf(stderr, "\n");

    exit(1);
}

void DRPwarning(char *fmt, ...)
{
    va_list args;

    va_start(args, fmt);
    fprintf(stderr, "%s -- warning: ", PROGRAM_NAME);
    vfprintf(stderr, fmt, args);
    fprintf(stderr, "\n");

    return;
}

void DRPinfo(char *fmt, ...)
{
    va_list args;

    va_start(args, fmt);
    printf("%s -- ", PROGRAM_NAME);
    vprintf(fmt, args);
    printf("\n");

    return;
}

