#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
char PROGRAM_NAME[] = "fft";
char description[] = "FFT of 'work' area, result in 'temp'";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-invert",                    "perform inverse transformation" },
{ "-power",                     "calculate periodogram" },
{NULL, NULL }};

#define TRANSFORMED 1

static int invert = 0;
static int power  = 0;

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "invert")) {
	invert = 1;
	return;
    }
    if (!strcmp(opt, "power")) {
	power = 1;
	return;
    }
    Syntax(**pargv);
}

void realft(float [], int , int );

SCAN OnScan;
  
int main (int argc, char *argv[])
{
/*    double delta; */
    int nch, n;
    int i;
  
    GetOpts(argc, argv);
    GetScan (&OnScan);

    nch = OnScan.NChannel;
    for (n = 1; n < 2048; n *= 2) if (n >= nch) break;
/*    delta = nch*OnScan.FreqRes; */
 
    if (invert) {
	if (OnScan.flag[10] != TRANSFORMED) {
	    DRPerror("this is not a Fourier-transformed spectrum");
	}
	realft (OnScan.Channels, n/2, -1);
	for (i = 0; i < n; i++) OnScan.Channels[i] /= (float)(n/2);
	OnScan.NChannel = OnScan.flag[11];
	OnScan.flag[10] = OnScan.flag[11] = 0;
/*
	OnScan.FreqRes = 0.5/delta;
	OnScan.Bandwidth = nch*OnScan.FreqRes;
	OnScan.RestFreq = 0.0;
*/
    } else {
	if (OnScan.flag[10] == TRANSFORMED) {
	    DRPerror("this spectrum is already Fourier-transformed");
	}
	for (i = OnScan.NChannel; i < n; i++) OnScan.Channels[i] = 0.0;
	realft (OnScan.Channels, n/2, 1);
	OnScan.NChannel = n;
	OnScan.flag[10] = TRANSFORMED;
	OnScan.flag[11] = nch;
/*
	OnScan.FreqRes = 0.5/delta;
	OnScan.Bandwidth = nch*OnScan.FreqRes;
	OnScan.RestFreq = OnScan.Bandwidth/2.0;
*/
	if (power) {
	    for (i = 0; i < OnScan.NChannel; i++) OnScan.Channels[i] /= (float)nch;
	    OnScan.Channels[0] = OnScan.Channels[1]*OnScan.Channels[1];
	    for (i = 2; i < OnScan.NChannel; i+=2) {
		OnScan.Channels[i/2] =
		  OnScan.Channels[i]*OnScan.Channels[i]
		    +OnScan.Channels[i+1]*OnScan.Channels[i+1];
	    }
	    OnScan.NChannel /= 2;
	    OnScan.FreqRes *= 2.0;
	}
    }
    PutTemp(&OnScan);
  
    exit(0);
}
