#define LOGRECLEN     80
#define PHYSRECLEN  2880
#define KEYWORDLEN     8
#define MAXVARLEN     40

#define NVARTYPE 0
#define BOOLTYPE 1
#define CHARTYPE 2
#define LONGTYPE 3
#define REALTYPE 5
#define CPLXTYPE 6

#define MAXNAXIS 5

enum kw_known {
    KW_SIMPLE, 
    KW_XTENSION,
    KW_BITPIX,
    KW_NAXIS, 
    KW_CTYPE,
    KW_CRPIX,
    KW_CRVAL,
    KW_CDELT,
    KW_CROTA,
    KW_BSCALE,
    KW_BZERO,
    KW_BUNIT,
    KW_BLANK,
    KW_DATAMAX,
    KW_DATAMIN,
    KW_ORIGIN,
    KW_OBSERVER,
    KW_OBJECT,
    KW_INSTRUME,
    KW_TELESCOP,
    KW_LINE,
    KW_SCAN,
    KW_UTC,
    KW_LST,
    KW_DATE_OBS,
    KW_DATE,
    KW_JDATE,
    KW_TSYS,
    KW_TLOAD,
    KW_TREC,
    KW_TAU,
    KW_DBLOAD,
    KW_EQUINOX,
    KW_RA,
    KW_DEC,
    KW_AZIMUTH,
    KW_ELEVATIO,
    KW_AZOFF,
    KW_ELOFF,
    KW_AZPOINT,
    KW_ELPOINT,
    KW_AZCORR,
    KW_ELCORR,
    KW_COLLIMAT,
    KW_RESTFREQ,
    KW_VLSR,
    KW_VHEL,
    KW_VELO_LSR,
    KW_VELO_HEL,
    KW_VELO_GEO,
    KW_DELTAV,
    KW_OBSTIME,
    KW_TAMB,
    KW_TOUTSIDE,
    KW_PRESSURE,
    KW_HUMIDITY,
    KW_POSLONG,
    KW_POSLAT,
    KW_SPACELON,
    KW_SPACELAT,
    KW_MAPTILT,
    KW_COMMENT,
    KW_HISTORY,
    KW_EXTEND,
    KW_PCOUNT,
    KW_GCOUNT,
    KW_TFIELDS,
    KW_EXTNAME,
    KW_EXTVER,
    KW_NMATRIX,
    KW_MAXIS,
    KW_TFORM,
    KW_TTYPE,
    KW_TUNIT,
    KW_TDIM,
    KW_END
};

struct knownkey {
    int key;
    int typ;
    char text[KEYWORDLEN+1];
};

#ifdef FITSKNOWN
struct knownkey known[] = {
    { KW_SIMPLE, BOOLTYPE, "SIMPLE" },
    { KW_XTENSION, CHARTYPE, "XTENSION" },
    { KW_BITPIX, LONGTYPE, "BITPIX" },
    { KW_NAXIS, LONGTYPE, "NAXIS" },
    { KW_CTYPE, CHARTYPE, "CTYPE" },
    { KW_CRPIX, REALTYPE, "CRPIX" },
    { KW_CRVAL, REALTYPE, "CRVAL" },
    { KW_CDELT, REALTYPE, "CDELT" },
    { KW_CROTA, REALTYPE, "CROTA" },
    { KW_BSCALE, REALTYPE, "BSCALE" },
    { KW_BZERO, REALTYPE, "BZERO" },
    { KW_BUNIT, CHARTYPE, "BUNIT" },
    { KW_BLANK, REALTYPE, "BLANK" },
    { KW_DATAMAX, REALTYPE, "DATAMAX" },
    { KW_DATAMIN, REALTYPE, "DATAMIN" },
    { KW_ORIGIN, CHARTYPE, "ORIGIN" },
    { KW_OBSERVER, CHARTYPE, "OBSERVER" },
    { KW_OBJECT, CHARTYPE, "OBJECT" },
    { KW_INSTRUME,CHARTYPE, "INSTRUME" },
    { KW_TELESCOP, CHARTYPE, "TELESCOP" },
    { KW_LINE, CHARTYPE, "LINE" },
    { KW_SCAN, REALTYPE, "SCAN-NUM" },
    { KW_UTC, CHARTYPE, "UTC" },           /* { 0, "UTIME   ", REALTYPE }, */
    { KW_LST, CHARTYPE, "LST" },           /* { 0, "SIDTIME ", REALTYPE }, */
    { KW_DATE_OBS, CHARTYPE, "DATE-OBS" }, /* { 0, "DATEOBS ", CHARTYPE }, */
    { KW_DATE, CHARTYPE, "DATE" },
    { KW_JDATE, REALTYPE, "JDATE" },
    { KW_TSYS, REALTYPE, "TSYS" },
    { KW_TLOAD, REALTYPE, "TLOAD" },
    { KW_TREC, REALTYPE, "TREC" },
    { KW_TAU, REALTYPE, "TAU-ATM" },
    { KW_DBLOAD, REALTYPE, "DBLOAD" },
    { KW_EQUINOX, REALTYPE, "EQUINOX" },   /* { 0, "EPOCH   ", REALTYPE }, */
    { KW_RA, REALTYPE, "RA" },
    { KW_DEC, REALTYPE, "DEC" },
    { KW_AZIMUTH, REALTYPE, "AZIMUTH" },   /* { 0, "AZ      ", REALTYPE }, */
    { KW_ELEVATIO, REALTYPE, "ELEVATIO" }, /* { 0, "EL      ", REALTYPE }, */
    { KW_AZOFF, REALTYPE, "AZOFF" },
    { KW_ELOFF, REALTYPE, "ELOFF" },
    { KW_AZPOINT, REALTYPE, "AZPOINT" },
    { KW_ELPOINT, REALTYPE, "ELPOINT" },
    { KW_AZCORR, REALTYPE, "AZCORR" },
    { KW_ELCORR, REALTYPE, "ELCORR" },
    { KW_COLLIMAT, REALTYPE, "COLLIMAT" },
    { KW_RESTFREQ, REALTYPE, "RESTFREQ" },
    { KW_VLSR, REALTYPE, "VLSR" },
    { KW_VHEL, REALTYPE, "VHEL" },
    { KW_VELO_LSR, REALTYPE, "VELO-LSR" },
    { KW_VELO_HEL, REALTYPE, "VELO-HEL" },
    { KW_VELO_GEO, REALTYPE, "VELO-GEO" },
    { KW_DELTAV, REALTYPE, "DELTAV" },
    { KW_OBSTIME, REALTYPE, "OBSTIME" },
    { KW_TAMB, REALTYPE, "TAMB" },
    { KW_TOUTSIDE, REALTYPE, "TOUTSIDE" },
    { KW_PRESSURE, REALTYPE, "PRESSURE" },
    { KW_HUMIDITY, REALTYPE, "HUMIDITY" },
    { KW_POSLONG, LONGTYPE, "POSLONG" },
    { KW_POSLAT, LONGTYPE, "POSLAT" },
    { KW_SPACELON, REALTYPE, "SPACELON" },
    { KW_SPACELAT, REALTYPE, "SPACELAT" },
    { KW_MAPTILT, REALTYPE, "MAPTILT" },
    { KW_COMMENT, NVARTYPE, "COMMENT" },
    { KW_HISTORY, NVARTYPE, "HISTORY" },
    { KW_EXTEND, BOOLTYPE, "EXTEND" },
    { KW_PCOUNT, LONGTYPE, "PCOUNT" },
    { KW_GCOUNT, LONGTYPE, "GCOUNT" },
    { KW_TFIELDS, LONGTYPE, "TFIELDS" },
    { KW_EXTNAME, CHARTYPE, "EXTNAME" },
    { KW_EXTVER, LONGTYPE, "EXTVER" },
    { KW_NMATRIX, LONGTYPE, "NMATRIX" },
    { KW_MAXIS, LONGTYPE, "MAXIS" },
    { KW_TFORM, CHARTYPE, "TFORM" },
    { KW_TTYPE, CHARTYPE, "TTYPE" },
    { KW_TUNIT, CHARTYPE, "TUNIT" },
    { KW_TDIM, CHARTYPE, "TDIM" },
    { KW_END, NVARTYPE, "END" }
};
#else
extern struct knownkey known[];
#endif

struct fitskey {
    int key;
    int dim;
    union {
	char str[16];
	long l;
	double d;
	double c[2];
    } val;
};
