#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
#define FOLDED 6    /* used by 'header' */

double ft = 0.0;
int shift = 0;

char PROGRAM_NAME[] = "fold";
char description[] = "perform folding for frequency switched data"; 
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-throw throw",               "Specify frequency throw" },
{ "-shift",                     "shift resulting spectrum by half the throw" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(EX_SUCCESS);
    }
    if (!strcmp(opt, "throw")) {
	GetOption(&optarg, pargc, pargv);
	ft = atof(optarg);
	return;
    }
    if (!strcmp(opt, "shift")) {
	shift = 1;
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main (int argc, char *argv[])
{
    int i, n;
  
    GetOpts(argc, argv);

    GetScan (&OnScan);
    if (ft == 0.0) {
	ft = -OnScan.FreqThrow;
	if (ft == 0.0) DRPerror("no information on frequency throw");
    }
  
    n = (int)(ft/OnScan.FreqRes);
    if (n > 0) {
	for (i=0; i<OnScan.NChannel-n; i++) {
	    OnScan.Channels[i] -= OnScan.Channels[i+n];
	    OnScan.Channels[i] /= 2.0;
	}
	if (shift) {
	    n /= 2;
	    for (i=OnScan.NChannel-1; i>=n; i--) {
		OnScan.Channels[i] = OnScan.Channels[i-n];
	    }
	}
    } else {
	n = -n;
	for (i=OnScan.NChannel-1; i>=n; i--) {
	    OnScan.Channels[i] -= OnScan.Channels[i-n];
	    OnScan.Channels[i] /= 2.0;
	}
	if (shift) {
	    n /= 2;
	    for (i=0; i<OnScan.NChannel-n; i++) {
		OnScan.Channels[i+n] = OnScan.Channels[i];
	    }
	}
    }
  
    OnScan.ObsMode = FOLDED;
    PutScan (&OnScan);

    exit(EX_SUCCESS);
}
