#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include "drp.h"
#include "options.h"

#define READ 0
void scanio(char *, int, SCAN *);

static char scanname[MAXNAMLEN+1] = "";
static int temp = 0;

char PROGRAM_NAME[] = "get";
char description[] = "get scan in DRP binary format";
char required[] = "scannumber";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-file filename",             "specify full filename" },
{ "-temp",                      "read into temporary area" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "file")) {
	GetOption(&optarg, pargc, pargv);
	strcpy(scanname, optarg);
	return;
    }
    if (!strcmp(opt, "temp")) {
	temp = 1;
	return;
    }
    Syntax(**pargv);
}

static SCAN OnScan;

int main (int argc, char *argv[])
{
    DIR *dir;
    struct dirent *entry;
    char *ext;
    int found, scanno;

    GetOpts(argc, argv);
    if (argc <= 1) {
	Syntax("");
	exit(EX_ARGSBAD);
    } else {
	scanno = atoi(argv[1]);
    }

    if (scanname[0] == '\0') {
        if ((dir = opendir(".")) == NULL)
	  DRPerror("can't open current directory", PROGRAM_NAME);

	found = 0;
	while ((entry = readdir(dir)) != NULL) {
	    if ((ext = strrchr(entry->d_name, '.')) != NULL)  {
		if (ext && (scanno == atoi(++ext))) {
		    strcpy(scanname, entry->d_name);
		    found = 1;
		    break;
		}
	    }
	}
	if (!found) DRPerror("scan %d not found", scanno);
    }

    scanio(scanname, READ, &OnScan);
    if (OnScan.Version != (short)DRPVERSION) {
	if (OnScan.Version == HEADER + 2*OnScan.NChannel) {
	    /* old DRP scan, correct position for offsets */
	    OnScan.Longitude -= OnScan.LMapOff/cos(OnScan.Latitude);
	    OnScan.Latitude -= OnScan.BMapOff;
	}
	OnScan.Version = DRPVERSION;  /* indicate DRP version */
	DRPinfo("corrected version");
    }
    if (!temp) PutScan(&OnScan);
    else       PutTemp(&OnScan);
    DRPinfo("scan read from file '%s'", scanname);

    exit(0);
}
