#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#include "drp.h"

#define READ 0
#define WRITE 1

void scanio(char *which, int what, SCAN *s)
{
    FILE *sc;
    int h,d;

    switch (what) {
      case READ:
	sc = fopen(which, "r");
	if (sc == NULL) DRPerror("can't open file '%s'", which);

	h = fread((char *)s, 1, HEADER , sc);
	if (h != HEADER) DRPerror("error reading header record");

	d = fread((char *)s->Channels, sizeof(float), s->NChannel, sc);
	if (d != s->NChannel) DRPerror("error reading data record");

	fclose(sc);
	break;

      case WRITE: 
	sc = fopen(which, "w");
	if (sc == NULL) DRPerror("can't open file '%s'", which);

	h = fwrite((char *)s, 1, HEADER, sc);
	if (h != HEADER) DRPerror("error writing header record");

	d = fwrite((char *)s->Channels, sizeof(float), s->NChannel, sc);
	if (d != s->NChannel) DRPerror("error writing data record");

	fclose(sc);
	break;

      default:
	DRPerror("scanio called with wrong argument");
	break;
    }
}

#ifdef SHMCOM
#include "shmcom.h"
static SCAN *work;
static SCAN *temp;
static SCAN *hold;

int uid, qid, pid;
key_t key;
segment *ScanArea;

static void Attach(void);
static void Detach(void);

static void Attach(void)
{

 /* Get user ID and form a key by 'or'-ing it with a constant,
    this way we avoid conflicts with other users running DRP at 
    the same time */
    uid = getuid();
    pid = getpid();
    key = (key_t)(L_KEY | uid);
    if ((semid = semget(key, 1, 0)) == -1) {
        fprintf(stderr,"semget: can't get semaphore, DRP window not open?\n");
	exit(errno);
    }

    if ((shmid = shmget(key, sizeof(*ScanArea), 0)) == -1) {
        fprintf(stderr,"shmget: can't allocate DRP shared memory\n");
	exit(errno);
    }

    if (semop(semid, &seize, 1) == -1) {
        perror("semid");
	exit(errno);
    }

    ScanArea = (segment *)shmat(shmid, (char *)NULL, 0);
    if (ScanArea == (segment *)(-1)) {
	perror("shmat");
	exit(errno);
    }
    work = &(ScanArea->work);
    temp = &(ScanArea->temp);
    hold = &(ScanArea->hold);
}

static void Detach(void)
{
    if (semop(semid, &relse, 1) == -1) {
	perror("semop");
	return;
    }
    if (shmdt((char *)ScanArea) == -1) {
	perror("shmdt");
	return;
    }
}

void GetScan(SCAN *s)
{
    Attach();
    memcpy(s, work, sizeof(SCAN));
    Detach();
}

void PutScan(SCAN *s)
{
    Attach();
    memcpy(work, s, sizeof(SCAN));
    Detach();
}

void GetTemp(SCAN *s)
{
    Attach();
    memcpy(s, temp, sizeof(SCAN));
    Detach();
}

void PutTemp(SCAN *s)
{
    Attach();
    memcpy(temp, s, sizeof(SCAN));
    Detach();
}

void GetAve(SCAN *s)
{
    Attach();
    memcpy(s, hold, sizeof(SCAN));
    Detach();
}

void PutAve(SCAN *s)
{
    Attach();
    memcpy(hold, s, sizeof(SCAN));
    Detach();
}

#else 

char *cwork = "CWORK";
char *ctemp = "CTEMP";
char *chold = "CHOLD";

void PutScan(SCAN *s)
{
    scanio(cwork, WRITE, s);
}

void GetScan(SCAN *s)
{
    scanio(cwork, READ, s);
}

void PutTemp(SCAN *s)
{
    scanio(ctemp, WRITE, s);
}

void GetTemp(SCAN *s)
{
    scanio(ctemp, READ, s);
}

void PutAve(SCAN *s)
{
    scanio(chold, WRITE, s);
}

void GetAve(SCAN *s)
{
    scanio(chold, READ, s);
}
#endif
