#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
float scale = 0.0;

char PROGRAM_NAME[] = "ieee2convex";
char description[] = "turn all IEEE floats into CONVEX native format";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    Syntax(**pargv);
}

SCAN OnScan;

void IEEE2Convex()
{
    int i;

    OnScan.AirTemp *= 4.0;
    OnScan.Pressure *= 4.0;
    OnScan.Humidity *= 4.0;
    OnScan.Equinox *= 4.0;
    OnScan.EquiNow *= 4.0;
    OnScan.Longitude *= 4.0;
    OnScan.Latitude *= 4.0;
    OnScan.Long2000 *= 4.0;
    OnScan.Lat2000 *= 4.0;
    OnScan.LMapOff *= 4.0;
    OnScan.BMapOff *= 4.0;
    OnScan.Azimuth *= 4.0;
    OnScan.Elevation *= 4.0;
    OnScan.AzOffset *= 4.0;
    OnScan.ElOffset *= 4.0;
    OnScan.AzMapOff *= 4.0;
    OnScan.ElMapOff *= 4.0;
    OnScan.AzPointg *= 4.0;
    OnScan.ElPointg *= 4.0;
    OnScan.AzErrAve *= 4.0;
    OnScan.ElErrAve *= 4.0;
    OnScan.AzErrRms *= 4.0;
    OnScan.ElErrRms *= 4.0;
    OnScan.GalLong *= 4.0;
    OnScan.GalLat *= 4.0;
    OnScan.VHel *= 4.0;
    OnScan.VLsr *= 4.0;
    OnScan.Axial *= 4.0;
    OnScan.Shift *= 4.0;
    OnScan.VTilt *= 4.0;
    OnScan.HTilt *= 4.0;
    OnScan.Tcal *= 4.0;
    OnScan.Tsys *= 4.0;
    OnScan.Trec *= 4.0;
    OnScan.Tau *= 4.0;
    OnScan.dBl *= 4.0;
    OnScan.IntTime *= 4.0;
    OnScan.RefCorr *= 4.0;
    OnScan.ParAngle *= 4.0;
    OnScan.PosAngle *= 4.0;
    OnScan.StepX *= 4.0;
    OnScan.StepY *= 4.0;
    OnScan.Bandwidth *= 4.0;
    OnScan.RestFreq *= 4.0;
    OnScan.SkyFreq *= 4.0;
    OnScan.FirstIF *= 4.0;
    OnScan.FreqThrow *= 4.0;
    OnScan.FreqRes *= 4.0;
    OnScan.VSource *= 4.0;
    OnScan.VelRes *= 4.0;

    for (i=0; i<10; i++) OnScan.work[i] *= 4.0;
    for (i=0; i<OnScan.NChannel; i++) OnScan.Channels[i] *= 4.0;
}

int main (int argc, char *argv[])
{
    GetOpts(argc, argv);
    GetScan (&OnScan);
    IEEE2Convex();
    PutScan (&OnScan);
    exit(0);
}
