#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "drp.h"
#include "options.h"

#define FALSE     0

char PROGRAM_NAME[] = "inquire";
char description[] = "inquire spectral values with cursor";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    Syntax(**pargv);
}

XSizeHints hint;
static XEvent event;
typedef struct {
    float xoff;
    float xscl;
    float yoff;
    float yscl;
} World;

int main(int argc, char *argv[])
{
    int screen, x, y, format, n;
    unsigned int width, height, bwidth, depth;
    Window window, root, *retdata;
    Atom DRP_WINDOW, DRP_WORLD, DRP_DIMENSION, type;
    Display *dpy;
    /* Status status; */
    unsigned long nitems, left;
    GC gc;
    Colormap map;
    XColor xcolor, rgbcolor;
    static char keys[10];
    static World world, *worlddata;

    GetOpts(argc, argv);

    dpy = XOpenDisplay(NULL);
    if (dpy == NULL) DRPerror("can't open display");

    DRP_WINDOW = XInternAtom(dpy, "DRP Window", 0);
    DRP_WORLD = XInternAtom(dpy, "DRP World", 0);
    DRP_DIMENSION = XInternAtom(dpy, "DRP Dimension", 0);

    n = XGetWindowProperty(dpy, DefaultRootWindow(dpy), 
			   DRP_WINDOW, 
			   0, 1, FALSE, XA_WINDOW, 
			   &type, &format, 
			   &nitems, &left, 
			   (unsigned char **)&retdata);
    if (n != Success || type != XA_WINDOW) 
      DRPerror("can't retrieve window properties");

    window = *retdata;
    XSelectInput(dpy, window, ButtonPressMask|KeyPressMask);

    screen = DefaultScreen(dpy);
    map	= DefaultColormap(dpy, screen);
    gc = XCreateGC(dpy, window, 0, 0);
    XAllocNamedColor(dpy, map, "blue", &xcolor, &rgbcolor);
    XSetForeground(dpy, gc, xcolor.pixel);

    while (1) {
	XNextEvent(dpy, &event);
	switch (event.type) {
	  case ButtonPress:
	    if (event.xbutton.button == 1) {
		n = XGetWindowProperty(dpy, DefaultRootWindow(dpy), DRP_WORLD, 
				       0,sizeof(World)/4,FALSE,DRP_DIMENSION, 
				       &type, &format, &nitems, &left, 
				       (unsigned char **)&worlddata);
		if (n != Success || type != DRP_DIMENSION) 
		  DRPerror("can't retrieve window dimensions");
		world.xoff = worlddata->xoff;
		world.xscl = worlddata->xscl;
		world.yoff = worlddata->yoff;
		world.yscl = worlddata->yscl;
		/* status = */ XGetGeometry(dpy, window,
                                            &root, &x, &y, &width, &height, 
                                            &bwidth, &depth);
		XDrawLine(dpy, window, gc, event.xbutton.x-5, event.xbutton.y, event.xbutton.x+5, event.xbutton.y); 
		XDrawLine(dpy, window, gc, event.xbutton.x, event.xbutton.y-5, event.xbutton.x, event.xbutton.y+5); 
		printf("%10.4f %10.4f\n", 
		       world.xoff+event.xbutton.x*2*world.xscl,
		       world.yoff+(height-event.xbutton.y)*2*world.yscl);
	    } else {
		XCloseDisplay(dpy);
		exit(1);
	    }
	    break;
	  case KeyPress:
	    XLookupString((XKeyEvent *)&event, keys, 10, NULL, NULL);
	    if (keys[0] == 'q') {
		XCloseDisplay(dpy);
		exit(1);
	    }
	    break;
	  default:
	    break;
	}
    }

    exit (0);
}


