#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ftw.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include "drp.h"
#include "options.h"

#define NORMAL  0
#define NAME    1
#define NUMBER  2

#define FREQ    2
#define OFFSET  4

static int which = NORMAL;
static int what  = NORMAL;
static int header = 1;
static int namelen;
static char source[12] = "";
static double freq;
static float offx, offy;
static float headoffx, headoffy;

double radian(char *);

char PROGRAM_NAME[] = "list";
char description[] = "produce one line log messages for scan(s)";
char required[] = "filename(s)";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-names",                     "print filenames of scans only" },
{ "-numbers",                   "print scan numbers only" },
{ "-nohead",                    "don't print header lines" },
{ "-source name",               "list scans with given source name only" },
{ "-freq mhz",                  "list scans with given frequency only" },
{ "-offset offx offy",          "list scans with given map offsets" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "names")) {
	which = NAME;
	return;
    }
    if (!strcmp(opt, "numbers")) {
	which = NUMBER;
	return;
    }
    if (!strcmp(opt, "nohead")) {
	header = 0;
	return;
    }
    if (!strcmp(opt, "source")) {
	GetOption(&optarg, pargc, pargv);
        strcpy(source, optarg);
	what |= NAME;
	namelen = strlen(source);
	return;
    }
    if (!strcmp(opt, "freq")) {
	GetOption(&optarg, pargc, pargv);
	freq = atof(optarg);
	what |= FREQ;
	return;
    }
    if (!strcmp(opt, "offset")) {
	GetOption(&optarg, pargc, pargv);
	offx = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	offy = atof(optarg);
	printf("Offsets: %f,%f\n",offx,offy);
	what |= OFFSET;
	return;
    }
    if (!strcmp(opt, "help")) {
	Help();
	exit(EX_SUCCESS);
    }
    Syntax(**pargv);
}

#define READ 0

#define FALSE 0
#define TRUE 1
  
char *angle(float, int);

SCAN OnScan;
struct stat buf;
static int total;

#define NAMELEN 12

void headerline()
{
    /*                1         2         3         4         5         6 */
    /*       123456789012345678901234567890123456789012345678901234567890 */
    printf ("scan source     date.UTC    longitude     latitude    offsets");
    printf ("   freq  Tsys time\n");
    printf ("------------------------------------------------------");
    printf ("-------------------------\n");
}

void footerline()
{
    DRPinfo("total number of scans listed = %d", total);
}

void list_one(void)
{
    printf ("%04d ", OnScan.ScanNo);
    printf ("%.8s%", OnScan.Name);
    printf (" %02d%02d%02d.%02d%02d", 
	    OnScan.Year%100, OnScan.Month, OnScan.Day,
	    OnScan.UTHour, OnScan.UTMin);
    printf (" %s", angle(OnScan.Longitude,1));
    printf (" %s", angle(OnScan.Latitude,0));
    printf ("%5d", drpint((double)OnScan.LMapOff*RADTOSEC));
    printf ("%5d", drpint((double)OnScan.BMapOff*RADTOSEC));
    printf ("%7.0lf", OnScan.RestFreq);
    printf (" %5.0f", OnScan.Tsys);
    printf ("%5d\n", (int)(OnScan.IntTime));

    total++;
}

int open_scan(char *name, struct stat *statbuf, int flag)
{
    FILE *sc;
    int h;
int one;
int two;
int three;
one=1;
two=2;
three=3;
    if (flag != FTW_F) return (0);
    if ((statbuf->st_size - HEADER) % sizeof(float)) return (0);

    sc = fopen (name, "r");
    if (sc != NULL) {
printf("%i\n",one);
	h = fread((char *)&OnScan, 1, HEADER , sc);
printf(",bytes=%i\n",h);
	if (h == HEADER) {
printf("%i\n",two);
	    if ((OnScan.Version == (short int)DRPVERSION)
		|| (OnScan.Version == HEADER+OnScan.NChannel*sizeof(float))) {
printf("%i\n",three);
		if (what & NAME) {
		    if (strncmp(source, OnScan.Name, namelen)) return (0);
		}
		if (what & FREQ) {
		    if (fabs(freq - OnScan.RestFreq) > 1.0) return (0);
		}
		if (what & OFFSET) {
/*    printf ("%f", offx); */
    headoffx = (float)(drpint((double)OnScan.LMapOff*RADTOSEC));
    printf ("%f", headoffx);
    printf (",diff=%f; ", fabs(offx-headoffx));

/*    printf ("%f", offy); */
    headoffy = (float)(drpint((double)OnScan.BMapOff*RADTOSEC));
    printf ("%f", headoffy);
    printf (",diff=%f\n", fabs(offy-headoffy));

	    if (fabs(offx-headoffx)>1.0) return (0);
	    if (fabs(offy-headoffy)>1.0) return (0);
		}
		switch (which) {
		  case NAME:
		    printf("%s\n", name);
		    break;
		  case NUMBER:
		    printf("%04d\n", OnScan.ScanNo);
		    break;
		  default:
		    list_one();
		    break;
		}
/*		fclose (sc);
		return (1); */
	    }
	}
	fclose(sc);
    }
    return (0);
}

int main(int argc, char *argv[])
{
    DIR *dir;

    GetOpts(argc, argv);
    if (which != NORMAL) header = 0;

    if (argc == 1) {
	Syntax("");
	exit(EX_ARGSBAD);
    }

    if (header) headerline();

    while (--argc) {
	if (stat(*++argv, &buf)) continue;

	if ((buf.st_mode & S_IFMT) != S_IFDIR) {
	    if (buf.st_size >= HEADER) {
		if (open_scan(*argv, &buf, FTW_F)) {
		    continue;
		}
	    }
	} else {
	    ftw(*argv, open_scan, 15);
	}
    }

    if (header) footerline();

    if (total) exit(EX_SUCCESS); /* we found at least one scan */
    else       exit(EX_ARGSBAD);
}
