#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include "drp.h"
#include "options.h"

#define W 1.665109222   /* sqrt (4*ln2) */

double Amplitude = 1.0;
double Centre = 0.0;
double Width = 10.0;

char PROGRAM_NAME[] = "line";
char description[] = "produce gaussian line profile";
char required[] = "";
struct _options options[] = {
{ "-help",		"Print out this message" },
{ "-ampl amplitude",    "chose amplitude of linee" },
{ "-centre centre",     "chose centre of line" },
{ "-width width",       "chose width of line" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "ampl")) {
	GetOption(&optarg, pargc, pargv);
	Amplitude = atof(optarg);
	return;
    }
    if (!strcmp(opt, "centre")) {
	GetOption(&optarg, pargc, pargv);
	Centre = atof(optarg);
	return;
    }
    if (!strcmp(opt, "width")) {
	GetOption(&optarg, pargc, pargv);
	Width = atof(optarg);
	return;
    }

    Syntax(**pargv);
}

struct scan OnScan;
  
int main (int argc, char *argv[])
{
    int i;
    double x;
    struct tm *now;
    time_t clock;

    GetOpts(argc, argv);

    time(&clock);
    now = gmtime(&clock);

    OnScan.NChannel = MAXCHANNELS/4;
    OnScan.Version = DRPVERSION;
    OnScan.ScanNo = 1;
    OnScan.SubScan = 0;
    OnScan.Year  = now->tm_year+1900;
    OnScan.Month = now->tm_mon+1;
    OnScan.Day   = now->tm_mday;;
    OnScan.UTHour = now->tm_hour;
    OnScan.UTMin  = now->tm_min;
    OnScan.UTSec  = now->tm_sec;
    OnScan.STHour = 0;
    OnScan.STMin  = 0;
    OnScan.STSec  = 0;
    strncpy(OnScan.Name, "LINE        ", 12); 
    OnScan.Longitude = 0.0;
    OnScan.Latitude  = 0.0;
    OnScan.Azimuth   = 0.0;
    OnScan.Elevation = 0.0;
    OnScan.Tcal    = 250.0;
    OnScan.Tsys    = 500.0;
    OnScan.IntTime = 1.0;
    OnScan.Bandwidth = (double)OnScan.NChannel;
    OnScan.FreqRes   = 0.1;
    OnScan.RestFreq  = 100000.0;
    OnScan.SkyFreq   = 100000.0;
    OnScan.VSource   = 0.0;
    OnScan.VelRes    = -C*1.0e-3*OnScan.FreqRes/OnScan.RestFreq;

    for (i = 0; i < OnScan.NChannel; i++) {
	x = W*(Velocity(i, &OnScan)-Centre)/Width;
	OnScan.Channels[i] = Amplitude*exp(-x*x);
    }
    PutScan (&OnScan);
  
    exit (0);
}


