#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
#define FOLDED 6    /* used by 'header' */

int drpint(double);
double ft = 0.0;
int shift = 0;

/* based on:
 * A&A Supplement Ser., Vol. 124, July 1997, 183-188
 */
char PROGRAM_NAME[] = "liszt";
char description[] = "perform Liszt type of folding for frequency switched data"; 
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-throw throw",               "Specify frequency throw" },
{ "-shift",                     "shift resulting spectrum by half the throw" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(EX_SUCCESS);
    }
    if (!strcmp(opt, "throw")) {
	GetOption(&optarg, pargc, pargv);
	ft = atof(optarg);
	return;
    }
    if (!strcmp(opt, "shift")) {
	shift = 1;
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main (int argc, char *argv[])
{
  int i, n;
  static float sig[MAXCHANNELS], ref[MAXCHANNELS];

  GetOpts(argc, argv);

  GetScan (&OnScan);
  if (ft == 0.0) {
    ft = -OnScan.FreqThrow;
    if (ft == 0.0) DRPerror("no information on frequency throw");
  }
  
  n = drpint(ft/OnScan.FreqRes);

  if (n > 0) {
    for (i = 0; i < n; i++) 
      sig[i] = OnScan.Channels[i];
    for (i = n; i < OnScan.NChannel; i++) 
      sig[i] = OnScan.Channels[i] + sig[i-n];
    
    for (i = OnScan.NChannel-1; i >= OnScan.NChannel-n; i--) {
      ref[i] = OnScan.Channels[i];
      OnScan.Channels[i] = 0.0;
    }
    for (i = OnScan.NChannel-n-1; i >= 0; i--) {
      ref[i] = OnScan.Channels[i] + ref[i+n];
      OnScan.Channels[i] = (sig[i] - ref[i+n])/2.0;
    }
  } else {
    n = -n;
    for (i = OnScan.NChannel-1; i >= OnScan.NChannel-n; i--)
      sig[i] = OnScan.Channels[i];
    for (i = OnScan.NChannel-n-1; i >= 0; i--)
      sig[i] = OnScan.Channels[i] + sig[i+n];

    for (i = 0; i < n; i++) {
      ref[i] = OnScan.Channels[i];
      OnScan.Channels[i] = 0.0;
    }
    for (i = n; i < OnScan.NChannel; i++) {
      ref[i] = OnScan.Channels[i] + ref[i-n];
      OnScan.Channels[i] = (sig[i] - ref[i-n])/2.0;
    }
  }

  PutScan (&OnScan);

  exit(EX_SUCCESS);
}
