#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <math.h>
#include <ctype.h>
#include "drp.h"
#include "plplot.h"
#include "options.h"
  
#define SIZE  4000
int list[SIZE];

#define YES  1
#define NO   0

#define COVER 0
#define CONTR 1
#define SCANS 2
#define VALUE 3
#define SHADE 4
#define SPECT 5
  
/* defaults */
double xMin = 0.0, xMax = 0.0;
double yMin = 0.0, yMax = 0.0;
int xUnit = VELOCITY;
int which = COVER;
int frame = YES;
int col = 1;
int pen = 1;
int overwrite = NO;
int mark = NO;
int smooth = NO;
int draft = YES;
int title = NO;
int label[2] = { NO, NO };
char markfile[MAXNAMLEN+1] = "";
char NewTitle[80];
char xLabel[80], yLabel[80];
char keyword[10];
float level = 0.0;
float dl = 0.0;

void plsfile(FILE *);

char PROGRAM_NAME[] = "mapshow";
char description[] = "produce contour/coverage maps from log file";
char required[] = "";
struct _options options[] = {
{ "-help",		"print out this message" },
{ "-key keyword",       "specify keyword in 'drp.log' file" },
{ "-col number",        "specify column number to map" },
{ "-pen number",        "specify pen (line style) to be used" },
{ "-map what",          "what: cover, scan#, contr, value, shade, spect" },
{ "-start level",       "specify lowest level for contour maps" },
{ "-inc increment",     "specify level increments" },
{ "-mark filename",     "supply filename for offset positions to be marked" },
{ "-title text",        "specify new title for plot" },
{ "-xlabel text",       "specify new label for x-axis" },
{ "-ylabel text",       "specify new label for y-axis" },
{ "-over",		"write over existing plot" },
{ "-smooth",		"use B-splines to get smooth contours" },
{ "-nodraft",		"use extended font for high quality labels" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(EX_SUCCESS);
    }
    if (!strcmp(opt, "key")) {
	GetOption(&optarg, pargc, pargv);
	strcpy(keyword, optarg);
	return;
    }
    if (!strcmp(opt, "col")) {
	GetOption(&optarg, pargc, pargv);
	col = atoi(optarg);
	return;
    }
    if (!strcmp(opt, "pen")) {
	GetOption(&optarg, pargc, pargv);
	pen = atoi(optarg);
	return;
    }
    if (!strcmp(opt, "map")) {
	GetOption(&optarg, pargc, pargv);
	for (opt = optarg; *opt != '\0'; opt++) *opt = toupper(*opt);
	if (strncmp(optarg, "COVER", 5) == 0) which = COVER;
	if (strncmp(optarg, "SCAN#", 5) == 0) which = SCANS;
	if (strncmp(optarg, "CONTR", 5) == 0) which = CONTR;
	if (strncmp(optarg, "VALUE", 5) == 0) which = VALUE;
	if (strncmp(optarg, "SHADE", 5) == 0) which = SHADE;
	if (strncmp(optarg, "SPECT", 5) == 0) which = SPECT;
	return;
    }
    if (!strcmp(opt, "start")) {
	GetOption(&optarg, pargc, pargv);
	level = atof(optarg);
	return;
    }
    if (!strcmp(opt, "inc")) {
	GetOption(&optarg, pargc, pargv);
	dl = atof(optarg);
	return;
    }
    if (!strcmp(opt, "title")) {
	title = YES;
	GetOption(&optarg, pargc, pargv);
	strcpy(NewTitle, optarg);
	return;
    }
    if (!strcmp(opt, "xlabel")) {
	label[0] = YES;
	GetOption(&optarg, pargc, pargv);
	strcpy(xLabel, optarg);
	return;
    }
    if (!strcmp(opt, "ylabel")) {
	label[1] = YES;
	GetOption(&optarg, pargc, pargv);
	strcpy(yLabel, optarg);
	return;
    }
    if (!strcmp(opt, "over")) {
	overwrite = YES;
	frame = NO;
	return;
    }
    if (!strcmp(opt, "smooth")) {
	smooth = YES;
	return;
    }
    if (!strcmp(opt, "nodraft")) {
	draft = NO;
	return;
    }
    if (!strcmp(opt, "mark")) {
	GetOption(&optarg, pargc, pargv);
	mark = YES;
	strcpy(markfile, optarg);
	return;
    }
    if (!strcmp(opt, "vel")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	xUnit = VELOCITY;
	return;
    }
    if (!strcmp(opt, "freq")) {
	GetOption(&optarg, pargc, pargv);
	xMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = atof(optarg);
	xUnit = FREQUENCY;
	return;
    }
    if (!strcmp(opt, "chan")) {
	GetOption(&optarg, pargc, pargv);
	xMin = (double)atoi(optarg);
	GetOption(&optarg, pargc, pargv);
	xMax = (double)atoi(optarg);
	xUnit = CHANNELS;
	return;
    }
    if (!strcmp(opt, "temp")) {
	GetOption(&optarg, pargc, pargv);
	yMin = atof(optarg);
	GetOption(&optarg, pargc, pargv);
	yMax = atof(optarg);
	return;
    }
    Syntax(**pargv);
}

void scanlog(void);
void showmap(void);
  
int main (int argc, char *argv[])
{
    FILE *meta;
    double swap;
    static char metaname[MAXNAMLEN+1];
  
    GetOpts(argc, argv);

    if (xMin > xMax) {	swap = xMin;	xMin = xMax;	xMax = swap;    }
    if (yMin > yMax) {	swap = yMin;	yMin = yMax;	yMax = swap;    }


#ifdef DEBUG
    printf(" options:\n");
    printf(" keyword = %s\n", keyword);
    printf(" map     = %d\n", which);
    printf(" start   = %f\n", level);
    printf(" inc     = %f\n", dl);
    printf(" over    = %d\n", overwrite);
#endif

    scanlog();

    if (fork() == 0) {
	strcpy(metaname, getenv("HOME"));
	strcat(metaname, METAFILE);
	if (!overwrite) meta = fopen(metaname, "w");
	else            meta = fopen(metaname, "a");
	if (meta == NULL) DRPerror("can't open metacode file '%s'", metaname);
	plsfile(meta);
	plstart("plmeta", 1, 1); 
    } else {
	plstart(PLDEVICE, 1, 1); 
	if (!overwrite) plclr();
    }

    if (!draft) {
	plfontld(1);
	plfont(2);
	plwid(4);
    }

    showmap();
    plend();

    exit(EX_SUCCESS);
}
