#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
#define VIEWPORT  2
  
static int minx = -10;
static int maxx =  10;
static int miny = -10;
static int maxy =  10;
static int reverse = 0;

char PROGRAM_NAME[] = "mapview";
char description[] = "set viewport dimension for succeeding show operation";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-limits xmin ymin xmax ymax","set map limits" },
{ "-reverse",                   "reverse map" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(EX_SUCCESS);
    }
    if (!strcmp(opt, "limits")) {
	GetOption(&optarg, pargc, pargv);
	minx = atoi(optarg);
	GetOption(&optarg, pargc, pargv);
	miny = atoi(optarg);
	GetOption(&optarg, pargc, pargv);
	maxx = atoi(optarg);
	GetOption(&optarg, pargc, pargv);
	maxy = atoi(optarg);
        return;
    }
    if (!strcmp(opt, "reverse")) {
	reverse = 1;
        return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main (int argc, char *argv[])
{
    float VxMin, VxMax, VyMin, VyMax, swap;
  
    GetOpts(argc, argv);
    GetScan (&OnScan);
  
    if (OnScan.LMapOff == 0.0 && OnScan.BMapOff == 0.0) {
	OnScan.MapX = 0; OnScan.MapY = 0;
    }
    if (OnScan.MapX < minx || OnScan.MapX > maxx
	|| OnScan.MapY < miny || OnScan.MapY > maxy) {
	DRPerror("scan outside selected range");
    }
  
    VxMin = 0.05 + 0.9*((float)maxx-OnScan.MapX)/(float)(maxx-minx+1);
    VxMax = 0.05 + 0.9*((float)maxx-OnScan.MapX+1)/(float)(maxx-minx+1);
    VyMin = 0.05 + 0.9*(OnScan.MapY-(float)miny)/(float)(maxy-miny+1);
    VyMax = 0.05 + 0.9*(OnScan.MapY+1-(float)miny)/(float)(maxy-miny+1);
    if (reverse) {
	swap = VxMin; VxMin = VyMin; VyMin = swap;
	swap = VxMax; VxMax = VyMax; VyMax = swap;
    }
  
    OnScan.flag[2] = VIEWPORT;
    OnScan.work[4] = VxMin;
    OnScan.work[5] = VxMax;
    OnScan.work[6] = VyMin;
    OnScan.work[7] = VyMax;
    DRPinfo("viewport %d %d:%d (%f, %f) - (%f, %f)", OnScan.ScanNo, 
	OnScan.MapX, OnScan.MapY,
	VxMin, VxMax, VyMin, VyMax);
  
    PutScan(&OnScan);
  
    exit(EX_SUCCESS);
}
