#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "drp.h"

/* #include "nrutil.h" */

#define NRANSI

void covsrt(double **covar, int ma, int ia[], int mfit)
{
    int i, j, k;
    double swap;

    for (i = mfit; i < ma; i++)
      for (j = 0; j <= i; j++) covar[i][j] = covar[j][i] = 0.0;
    k = mfit-1;
    for (j = ma-1; j >= 0; j--) {
	if (ia[j]) {
	    if (k != j) {
		/* printf("swapping %d,%d\n", k, j); */
		for (i = 0; i < ma; i++) {
		    swap = covar[i][k];
		    covar[i][k] = covar[i][j];
		    covar[i][j] = swap;
		}
		for (i = 0; i < ma; i++) {
		    swap = covar[k][i];
		    covar[k][i] = covar[j][i];
		    covar[j][i] = swap;
		}
	    }
	    k--;
	}
    }
}

void gaussj(double **a, int n, double **b, int m)
{
    int *indxc, *indxr, *ipiv;
    int i, icol = 0, irow = 0, j, k, l, ll;
    double big, dum, pivinv, swap;

    indxc = (int *)calloc(n, sizeof(int));
    if (indxc == (int *)NULL) DRPerror("memory allocation failure");
    indxr = (int *)calloc(n, sizeof(int));
    if (indxr == (int *)NULL) DRPerror("memory allocation failure");
    ipiv = (int *)calloc(n, sizeof(int));
    if (ipiv == (int *)NULL) DRPerror("memory allocation failure");

    for (j = 0; j < n; j++) ipiv[j]=0;
    for (i = 0; i < n; i++) {
	big=0.0;
	for (j = 0; j < n; j++)
	  if (ipiv[j] != 1)
	    for (k = 0; k < n; k++) {
		if (ipiv[k] == 0) {
		    if (fabs(a[j][k]) >= big) {
			big = fabs(a[j][k]);
			irow = j;
			icol = k;
		    }
		} else if (ipiv[k] > 1) DRPerror("singular matrix (1)");
	    }
	++(ipiv[icol]);
	if (irow != icol) {
	    for (l = 0;l < n; l++) {
		swap = a[irow][l];
		a[irow][l] = a[icol][l];
		a[icol][l] = swap;
	    }
	    for (l = 0; l < m; l++) {
		swap = b[irow][l];
		b[irow][l] = b[icol][l];
		b[icol][l] = swap;
	    }
	}
	indxr[i] = irow;
	indxc[i] = icol;
	if (a[icol][icol] == 0.0) DRPerror("singular matrix (2)");
	pivinv = 1.0/a[icol][icol];
	a[icol][icol] = 1.0;
	for (l = 0; l < n; l++) a[icol][l] *= pivinv;
	for (l = 0; l < m; l++) b[icol][l] *= pivinv;
	for (ll = 0; ll < n; ll++)
	  if (ll != icol) {
	      dum = a[ll][icol];
	      a[ll][icol] = 0.0;
	      for (l = 0;l < n;l++) a[ll][l] -= a[icol][l]*dum;
	      for (l = 0;l < m;l++) b[ll][l] -= b[icol][l]*dum;
	  }
    }
    for (l = n-1 ;l >= 0; l--) {
	if (indxr[l] != indxc[l])
	  for (k = 0;k < n; k++) {
	      swap = a[k][indxr[l]];
	      a[k][indxr[l]] = a[k][indxc[l]];
	      a[k][indxc[l]] = swap;
	  }
    }
    free(ipiv);
    free(indxr);
    free(indxc);
}

void mrqcof(double x[], double y[], double sig[], int ndata, 
	    double a[], int ia[], int ma, 
	    double **alpha, double beta[], double *chisq,
	    double (*funcs)(double, double [], double [], int))
{
    int i, j, k, l, m, mfit = 0;
    double ymod, wt, sig2i, dy, *dyda;

    dyda = (double *)calloc(ma, sizeof(double));
    if (dyda == (double *)NULL) DRPerror("memory allocation failure");

    for (j = 0; j < ma; j++) if (ia[j]) mfit++;
    for (j = 0; j < mfit; j++) {
	for (k = 0; k <= j; k++) alpha[j][k] = 0.0;
	beta[j] = 0.0;
    }

    *chisq = 0.0;
    for (i = 0; i < ndata; i++) {
	ymod = (*funcs)(x[i], a, dyda, ma);
	sig2i = 1.0/(sig[i]*sig[i]);
	dy = y[i] - ymod;
	for (j = -1, l = 0; l < ma; l++) {
	    if (ia[l]) {
		wt = dyda[l]*sig2i;
		for (j++, k = 0, m = 0; m <= l; m++) {
		    if (ia[m]) {
			alpha[j][k] += wt*dyda[m];
			k++;
		    }
		}
		beta[j] += dy*wt;
	    }
	}
	*chisq += dy*dy*sig2i;
    }
    for (j = 1; j < mfit; j++)
      for (k = 0; k < j; k++) alpha[k][j] = alpha[j][k];

    free(dyda);
}

void mrqmin(double x[], double y[], double sig[], int ndata, 
	    double a[], int ia[], int ma, 
	    double **covar, double **alpha, double *chisq,
	    double (*funcs)(double, double [], double [], int), 
	    double *alamda)
{
    void covsrt(double **covar, int ma, int ia[], int mfit);
    void gaussj(double **a, int n, double **b, int m);
    void mrqcof(double x[], double y[], double sig[], int ndata, double a[],
		int ia[], int ma, double **alpha, double beta[], double *chisq,
		double (*funcs)(double, double [], double [], int));
    int i, j, k, l;
    static int mfit;
    static double ochisq, *atry, *beta, *da, **oneda;

    if (*alamda < 0.0) {
	atry = (double *)calloc(ma, sizeof(double));
	if (atry == (double *)NULL) DRPerror("memory allocation failure");

	beta = (double *)calloc(ma, sizeof(double));
	if (beta == (double *)NULL) DRPerror("memory allocation failure");

	da = (double *)calloc(ma, sizeof(double));
	if (da == (double *)NULL) DRPerror("memory allocation failure");

	for (mfit = 0, j = 0; j < ma; j++)
	  if (ia[j]) mfit++;

	oneda = (double **)calloc(mfit, sizeof(double *));
	if (oneda == (double **)NULL) DRPerror("memory allocation failure");
	oneda[0] = (double *)calloc(mfit, sizeof(double));
	if (oneda[0] == (double *)NULL) DRPerror("memory allocation failure");
	for (i = 1; i < mfit; i++) {
	    oneda[i] = oneda[0] + i;
	}

	*alamda = 0.001;
	mrqcof(x, y, sig, ndata, a, ia, ma, alpha, beta, chisq, funcs);
	ochisq = (*chisq);

	for (j = 0; j < ma; j++) atry[j] = a[j];
    }

    for (j = 0; j < mfit; j++) {
	for (k = 0; k < mfit; k++) covar[j][k] = alpha[j][k];
	covar[j][j] = alpha[j][j]*(1.0+(*alamda));
	oneda[j][0] = beta[j];
    }
/*
    for (j = 0; j < mfit; j++) {
	for (k = 0; k < mfit; k++) printf("%lf ", covar[j][k]);
	printf(" = %lf\n", beta[j]);
    }
*/
    gaussj(covar, mfit, oneda, 1);
    for (j = 0; j < mfit; j++) da[j] = oneda[j][0];
    if (*alamda == 0.0) {
	covsrt(covar, ma, ia, mfit);
	free(oneda[0]);
	free(oneda);
	free(da);
	free(beta);
	free(atry);
	return;
    }
    for (j = 0, l = 0; l < ma; l++) if (ia[l]) atry[l] = a[l]+da[j++];
    mrqcof(x, y, sig, ndata, atry, ia, ma, covar, da, chisq, funcs);
    if (*chisq < ochisq) {
	*alamda *= 0.1;
	ochisq = (*chisq);
	for (j = 0; j < mfit; j++) {
	    for (k = 0; k < mfit; k++) alpha[j][k] = covar[j][k];
	    beta[j] = da[j];
	}
	for (l = 0; l < ma; l++) a[l] = atry[l];
    } else {
	*alamda *= 10.0;
	*chisq = ochisq;
    }
}
