#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "drp.h"
#include "options.h"

#define HEAD_SCANNO    1
#define HEAD_NAME      2
#define HEAD_POSITION  3
#define HEAD_MAPOFFS   4
#define HEAD_TSYS      5
#define HEAD_ITIME     6
#define HEAD_RESTFREQ  7
#define HEAD_SKYFREQ   8
#define HEAD_VSOURCE   9
#define DATA_CHANNEL  20

static int what;
static int number;
static char string[80];
static float f;
static double x, y;
static double d;
double radian(char *);

char PROGRAM_NAME[] = "modify";
char description[] = "modify header varables";
char required[] = "";
struct _options options[] = {
{ "-number n",	"modify scan number" },
{ "-name string",	"modify source name" },
{ "-channel i value",	"set channel i to value" },
{ "-pos x y", "modify source position" },
{ "-offs dx dy", "modify map offsets" },
{ "-tsys value", "modify system temperature" },
{ "-itime value", "modify integration time" },
{ "-rest value", "modify rest frequency" },
{ "-sky value", "modify sky frequency" },
{ "-vel value", "modify source velocity" },
{ "-help",	"Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "name")) {
	GetOption(&optarg, pargc, pargv);
	strcpy(string, optarg);
	what = HEAD_NAME;
	return;
    }
    if (!strcmp(opt, "number")) {
	GetOption(&optarg, pargc, pargv);
	number = atoi(optarg);
	what = HEAD_SCANNO;
	return;
    }
    if (!strcmp(opt, "pos")) {
	GetOption(&optarg, pargc, pargv);
	x = radian(optarg);
	GetOption(&optarg, pargc, pargv);
	y = radian(optarg);
	what = HEAD_POSITION;
	return;
    }
    if (!strcmp(opt, "offs")) {
	GetOption(&optarg, pargc, pargv);
	x = radian(optarg);
	GetOption(&optarg, pargc, pargv);
	y = radian(optarg);
	what = HEAD_MAPOFFS;
	return;
    }
    if (!strcmp(opt, "channel")) {
	GetOption(&optarg, pargc, pargv);
	number = atoi(optarg);
	GetOption(&optarg, pargc, pargv);
	f = (float)atof(optarg);
	what = DATA_CHANNEL;
	return;
    }
    if (!strcmp(opt, "tsys")) {
	GetOption(&optarg, pargc, pargv);
	f = (float)atof(optarg);
	what = HEAD_TSYS;
	return;
    }
    if (!strcmp(opt, "itime")) {
	GetOption(&optarg, pargc, pargv);
	f = (float)atof(optarg);
	what = HEAD_ITIME;
	return;
    }
    if (!strcmp(opt, "rest")) {
	GetOption(&optarg, pargc, pargv);
	d = atof(optarg);
	what = HEAD_RESTFREQ;
	return;
    }
    if (!strcmp(opt, "sky")) {
	GetOption(&optarg, pargc, pargv);
	d = atof(optarg);
	what = HEAD_SKYFREQ;
	return;
    }
    if (!strcmp(opt, "vel")) {
	GetOption(&optarg, pargc, pargv);
	d = atof(optarg);
	what = HEAD_VSOURCE;
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;
  
int main(int argc, char *argv[])
{
    GetOpts(argc, argv);

    if (argc == 1) DRPerror(" new scan number required as argument");
  
    GetScan (&OnScan);

    switch (what) {
      case HEAD_SCANNO:
	OnScan.ScanNo = abs(number)%10000;
	break;
      case HEAD_NAME:
	strncpy(OnScan.Name, string, 12);
	break;
      case HEAD_POSITION:
	OnScan.Longitude = (float)x;
	OnScan.Latitude = (float)y;
	break;
      case HEAD_MAPOFFS:
	OnScan.LMapOff = (float)x;
	OnScan.BMapOff = (float)y;
	break;
      case HEAD_TSYS:
	OnScan.Tsys = f;
	break;
      case HEAD_ITIME:
	OnScan.IntTime = f;
	break;
      case HEAD_RESTFREQ:
	OnScan.RestFreq = d;
	break;
      case HEAD_SKYFREQ:
	OnScan.SkyFreq = d;
	break;
      case HEAD_VSOURCE:
	OnScan.VSource = d;
	break;
      case DATA_CHANNEL:
	if (number < 0 || number > OnScan.NChannel-1)
	  DRPerror("channel number out of range");
	OnScan.Channels[number] = f;
	break;
    }

    PutScan (&OnScan);

    exit(0);
}
