#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "drp.h"
#include "options.h"

double Amplitude = 1.0;

char PROGRAM_NAME[] = "noise";
char description[] = "produce noise spectrum";
char required[] = "";
struct _options options[] = {
{ "-help",		"Print out this message" },
{ "-ampl amplitude",    "chose amplitude of noise" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "ampl")) {
	GetOption(&optarg, pargc, pargv);
	Amplitude = atof(optarg);
	return;
    }
    Syntax(**pargv);
}

#define M1 259200
#define IA1 7141
#define IC1 54773
#define RM1 (1.0/M1)
#define M2 134456
#define IA2 8121
#define IC2 28411
#define RM2 (1.0/M2)
#define M3 243000
#define IA3 4561
#define IC3 51349

static int idum = -1;

float ran1(int *idum)
{
    static long ix1,ix2,ix3;
    static float r[97];
    float temp;
    static int iff=0;
    int j;

    if (*idum < 0 || iff == 0) {
	iff=1;
	ix1=(IC1-(*idum)) % M1;
	ix1=(IA1*ix1+IC1) % M1;
	ix2=ix1 % M2;
	ix1=(IA1*ix1+IC1) % M1;
	ix3=ix1 % M3;
	for (j=0; j<97; j++) {
	    ix1=(IA1*ix1+IC1) % M1;
	    ix2=(IA2*ix2+IC2) % M2;
	    r[j]=(ix1+ix2*RM2)*RM1;
	}
	*idum=1;
    }
    ix1=(IA1*ix1+IC1) % M1;
    ix2=(IA2*ix2+IC2) % M2;
    ix3=(IA3*ix3+IC3) % M3;
    j=(97*ix3)/M3;
    if (j >= 97 || j < 0) {
	fprintf(stderr, "fatal error in 'ran1'\n");
	exit(1);
    }
    temp=r[j];
    r[j]=(ix1+ix2*RM2)*RM1;
    return temp;
}

float gasdev(int *idum)
{
    static int iset=0;
    static float gset;
    float fac,r,v1,v2;
    float ran1();

    if  (iset == 0) {
	do {
	    v1=2.0*ran1(idum)-1.0;
	    v2=2.0*ran1(idum)-1.0;
	    r=v1*v1+v2*v2;
	} while (r >= 1.0);
	fac=sqrt(-2.0*log(r)/r);
	gset=v1*fac;
	iset=1;
	return (v2*fac);
    } else {
	iset=0;
	return (gset);
    }
}

SCAN OnScan;
  
int main (int argc, char *argv[])
{
    int i;
    struct tm *now;
    time_t clock;

    GetOpts(argc, argv);

    time(&clock);
    now = gmtime(&clock);

    OnScan.NChannel = MAXCHANNELS/4;
    OnScan.Version = DRPVERSION;
    OnScan.ScanNo = 1;
    OnScan.SubScan = 0;
    OnScan.Year  = now->tm_year+1900;
    OnScan.Month = now->tm_mon+1;
    OnScan.Day   = now->tm_mday;;
    OnScan.UTHour = now->tm_hour;
    OnScan.UTMin  = now->tm_min;
    OnScan.UTSec  = now->tm_sec;
    OnScan.STHour = 0;
    OnScan.STMin  = 0;
    OnScan.STSec  = 0;
    strncpy(OnScan.Name, "NOISE       ", 12); 
    OnScan.Longitude = 0.0;
    OnScan.Latitude  = 0.0;
    OnScan.Azimuth   = 0.0;
    OnScan.Elevation = 0.0;
    OnScan.Tcal    = 250.0;
    OnScan.Tsys    = 500.0;
    OnScan.IntTime = 1.0;
    OnScan.Bandwidth = (double)OnScan.NChannel;
    OnScan.FreqRes   = 0.1;
    OnScan.RestFreq  = 100000.0;
    OnScan.SkyFreq   = 100000.0;
    OnScan.VSource   = 0.0;
    OnScan.VelRes    = -C*1.0e-3*OnScan.FreqRes/OnScan.RestFreq;

    idum = (int)time(NULL);
    idum = -idum;
    for (i=0; i<OnScan.NChannel; i++) {
	OnScan.Channels[i] = Amplitude*gasdev(&idum);
    }
    PutScan (&OnScan);
  
    exit (0);
}
