/* HPC, l, w, nr, "FITS, write a fits tape"; */
  
#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <time.h>
#include "drp.h"
  
static SCAN OnScan;

float dms (deg)
float deg;
{
   long cs;
   float dms;

   cs = (long)(deg*3600.0*10.0);
   dms = (float)(cs/36000L);
   dms += (float)((cs/600)%60)/100.0;
   dms += (float)(cs%600)/100000.0;
   return dms;
}

int main()
{
   struct tm *t;
   long clock;
   float hhmmss, ddmmss, rms;
   int i, yy, mon, dd, hh, min, ss, ty, tm, td;
  
/* get scan information */
   GetScan (&OnScan);
   time (&clock); t = gmtime (&clock);
   ty = t->tm_year; tm = t->tm_mon+1; td = t->tm_mday;
   yy = OnScan.Year; mon = OnScan.Month; dd = OnScan.Day;
   hh = OnScan.STHour; min = OnScan.STMin; ss = OnScan.STSec;
   if (yy > 1900) yy -= 1900;
   hhmmss = dms(OnScan.Longitude*RADTODEG/15.0);
   ddmmss = dms(OnScan.Latitude*RADTODEG);
   rms = OnScan.Tsys/sqrt(OnScan.Bandwidth*OnScan.IntTime*1.0e6);
  
   printf ("OBJECT    = '%.12s'\n", OnScan.Name);
   printf ("DATE_OBS  = '%02d/%02d/%02d'\n", mon, dd, yy);
   printf ("DATE_KEPT = '%02d/%02d/%02d'\n", tm, td, ty);
   printf ("LST       = '%02d:%02d:%02d'\n", hh, min, ss);
   printf ("SCAN      = %d\n", OnScan.ScanNo);
   printf ("RA        = %f\n", hhmmss);
   printf ("DEC       = %f\n", ddmmss);
   printf ("L         = %f\n", OnScan.GalLong*RADTODEG);
   printf ("B         = %f\n", OnScan.GalLat*RADTODEG);
   printf ("TC        = %f\n", OnScan.Tcal);
   printf ("TSYS      = %f\n", OnScan.Tsys);
   printf ("DUR       = %f\n", OnScan.IntTime);
   printf ("NCH       = %f\n", (float)OnScan.NChannel);
   printf ("AZ        = %f\n", OnScan.Azimuth*RADTODEG);
   printf ("EL        = %f\n", OnScan.Elevation*RADTODEG);
   printf ("RMS       = %f\n", rms);
   printf ("V         = %lf\n", OnScan.VSource);
   printf ("DV        = %lf\n", OnScan.VelRes);
   printf ("NU        = %lf\n", OnScan.RestFreq);
   printf ("DNU       = %lf\n", OnScan.FreqRes);
   printf ("VELDEF    = ' LSR  RADIO'\n");
   printf ("DATA\n");
   for (i=0; i<OnScan.NChannel; i++) printf ("%12f\n", OnScan.Channels[i]);
   printf ("END\n");
   exit (0);
}
