#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "drp.h"
#include "options.h"

double tilt = 0.0;
double incx, incy;

double radian(char *);

char PROGRAM_NAME[] = "pixel";
char description[] = "calculate map indices for given spacing";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-step dx dy",                "Specify map spacing" },
{ "-tilt tilt",                 "Specify tilt angle of map" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "step")) {
	GetOption(&optarg, pargc, pargv);
	incx = radian(optarg);
	GetOption(&optarg, pargc, pargv);
	incy = radian(optarg);
	return;
    }
    if (!strcmp(opt, "tilt")) {
	GetOption(&optarg, pargc, pargv);
	tilt = radian(optarg);
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main(int argc, char *argv[])
{
   double x, y;
   int xpix, ypix;

   GetOpts(argc, argv);
   if (incx == 0.0 || incy == 0.0) DRPerror("zero map spacing");

   GetScan (&OnScan);

   y = (double)OnScan.BMapOff*cos(tilt)+OnScan.LMapOff*sin(tilt);
   x = (double)OnScan.LMapOff*cos(tilt)-OnScan.BMapOff*sin(tilt);
   xpix = drpint(x/incx);
   ypix = drpint(y/incy);

   OnScan.MapX = xpix;
   OnScan.MapY = ypix;
   OnScan.StepX = (float)incx;
   OnScan.StepY = (float)incy;
   OnScan.PosAngle = (float)tilt;
   PutScan (&OnScan);

   DRPinfo("(%4d,%4d)", xpix, ypix);

   exit (0);
}
