#include <stdio.h>
#include <math.h>
#include "drp.h"
#include "plplot.h"
  
#define WINDOW     1
#define RELATIVE 256
  
#define NOSCALE  1
#define NOVIEW   2
  
static float xarray[2048];
static float yarray[2048];

#define NO  0
#define YES 1

int relative = NO;

SCAN Fit, OnScan;

int plfit(void)
{
    float xMin, xMax, yMin, yMax;
    float delta = 0.0, centre = 0.0;
    int FirstCh = 0, LastCh = 0, NCh, xUnit;
    int i;
  
    GetTemp (&Fit);
    GetScan (&OnScan);
    xUnit = OnScan.flag[0];
    if (OnScan.flag[1] & RELATIVE) relative = YES;
  
    switch (xUnit) {
      case VELOCITY:
	delta = (float)OnScan.VelRes;
	centre = (float)OnScan.VSource;
	break;
      case FREQUENCY:
	delta = (float)OnScan.FreqRes; 
	centre = (float)OnScan.RestFreq;
	break;
     case CHANNELS:
	delta = 1.0;
	centre = (float)CenterCh(&OnScan);
	break;
    }

    if (!(OnScan.flag[1] & WINDOW)) return(NOSCALE);
    xMin = OnScan.work[0];
    xMax = OnScan.work[1];
    yMin = OnScan.work[2];
    yMax = OnScan.work[3];
    if (relative) {
	xMin += centre;
	xMax += centre;
    }

    switch (xUnit) {
      case VELOCITY:
	FirstCh = VChannel((double)xMin, &Fit);
	LastCh = VChannel((double)xMax, &Fit);
	break;
      case FREQUENCY:
	FirstCh = FChannel((double)xMin, &Fit);
	LastCh = FChannel((double)xMax, &Fit);
	break;
     case CHANNELS:
	FirstCh = (int)xMin;
	LastCh = (int)xMax;
	break;
    }
    NCh = LastCh - FirstCh + 1;
    if (relative) {
	xMin -= centre;
	xMax -= centre;
    }

    for (i=0; i<NCh; i++) {
	xarray[i] = xMin + (float)i*delta;
	yarray[i] = Fit.Channels[FirstCh+i];
    }

    pladv(0);
    plvsta();
    plwind((PLFLT)xMin, (PLFLT)xMax, (PLFLT)yMin, (PLFLT)yMax);
    plbox("", (PLFLT)0.0, 0, "", (PLFLT)0.0, 0);
    plcol(1);
    plline(NCh, xarray, yarray);
    return (0);
}

