#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>
#include "drp.h"
#include "options.h"

#define WRITE 1
void scanio(char *, int, SCAN *);

static char scanname[MAXNAMLEN+1];
static int ask = 0;
static struct stat buf;

char PROGRAM_NAME[] = "put";
char description[] = "store scan in DRP binary format";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-file filename",             "specify full filename" },
{ "-ask",                       "ask to overwrite existing files" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "file")) {
	GetOption(&optarg, pargc, pargv);
	strcpy(scanname, optarg);
	return;
    }
    if (!strcmp(opt, "ask")) {
	ask = 1;
	return;
    }
    Syntax(**pargv);
}

void KillJunk(char s[])
{
    int i,j;

    for (i=0, j=0; i<strlen(s); i++)
      if (isalnum(s[i])) s[j++] = s[i];
    s[j++] = '\0';
}

SCAN OnScan;

int main (int argc, char *argv[])
{
    char ext[6], answer;

    GetOpts(argc, argv);
    GetScan(&OnScan);

    if (scanname[0] == '\0') {
        strncpy(scanname, OnScan.Name, 12);
        KillJunk(scanname);
        sprintf (ext, ".%04d", OnScan.ScanNo);
        strcat(scanname, ext);
    }

    if (ask) {
	if (stat(scanname, &buf) == 0) {
	    printf("overwrite existing file '%s'? ", scanname);
	    answer = getchar();
	    if (toupper(answer) != 'Y') exit(1);
	}
    }
    scanio(scanname, WRITE, &OnScan);
    DRPinfo("scan written to file '%s'", scanname);

    exit(0);
}
