#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
#include "dfil.h"

#define HEADERLEN 150

static char dfilname[MAXNAMLEN+1];
static DFWORD block = 0;
#ifdef CONVEX
static int dfil;
#endif
static int blocklen = 3;
static int receiver = 0;

char PROGRAM_NAME[] = "putants";
char description[] = "put scan into ANTS file (dfile)";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
#ifdef CONVEX
{ "-dfile",                      "specify 'dfile' number" },
#endif
{ "-file",                      "specify file name" },
{ "-block n",                   "specify block number" }, 
{ "-size n",                    "specify blocksize" }, 
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
#ifdef CONVEX
    if (!strcmp(opt, "dfile")) {
	GetOption(&optarg, pargc, pargv);
	dfil = atoi(optarg);
	return;
    }
#endif
    if (!strcmp(opt, "file")) {
	GetOption(&optarg, pargc, pargv);
	strcpy(dfilname, optarg);
	return;
    }
    if (!strcmp(opt, "block")) {
	GetOption(&optarg, pargc, pargv);
	block = atoi(optarg);
	return;
    }
    if (!strcmp(opt, "size")) {
	GetOption(&optarg, pargc, pargv);
	blocklen = atoi(optarg);
	return;
    }
    Syntax(**pargv);
}

DFWORD indx[DFILBLOCK];

SCAN OnScan;
struct dfscan AntsScan;

DFWORD *itwh;
float *twh;

short int dfint(short int value, int n)
{
    memcpy(itwh+n, &value, sizeof (DFWORD));
/*  printf("itwh[%3d]: %d\n", n, value); */
    return value;
}

float dffloat(float value, int n)
{
#ifndef CONVEX
    value *= 4.0;
#endif
    memcpy(itwh+n, &value, sizeof (float));
/*  printf("itwh[%3d]: %f\n", n, value); */
    return value;
}

double dfdble(double value, int n)
{
#ifndef CONVEX
    value *= 4.0;
#endif
    memcpy(itwh+n, &value, sizeof (double));
/*  printf("itwh[%3d]: %lf\n", n, value); */
    return (value);
}

void filltwh (SCAN *scan, int rec)
{
    int i;
    float *next;

    twh = (float *)itwh;
    dfint(scan->ScanNo, 0);
    dffloat((float)scan->NChannel, 2*(55+rec));
    dfint(scan->Day, 28);
    dfint(scan->Month, 27);
    dfint(scan->Year % 1900, 29);
    dffloat(((float)scan->UTHour*3600.0 
           + (float)scan->UTMin *  60.0 
           + (float)scan->UTSec)*15.0/RADTOSEC, 2*12);
    dffloat(((float)scan->STHour*3600.0
           + (float)scan->STMin *  60.0
           + (float)scan->STSec)*15.0/RADTOSEC, 2*11);
    itwh[30] = dfint(scan->ObsMode, 30);
    strncpy ((char *)(itwh+12), scan->Name, 12);
    strncpy ((char *)(itwh+8), scan->Project, 4);
    strncpy ((char *)(itwh+260), scan->Molecule, 18);
/*  dffloat((float)scan->JulDate, 2*9); */
    dfdble((double)scan->Longitude, 42);
    dfdble((double)scan->Latitude, 45);
    dffloat(scan->LMapOff, 2*90);
    dffloat(scan->BMapOff, 2*91);
    dffloat(scan->AzMapOff, 2*88);
    dffloat(scan->ElMapOff, 2*89);
    dfdble((double)scan->Azimuth, 164);
    dfdble((double)scan->Elevation, 167);
    dffloat(scan->Equinox, 2*24);
    dffloat(scan->Tsys, 2*(45+rec));
    dffloat(scan->Tcal, 2*(41+rec));
    dffloat(scan->Tau, 2*129);
    dffloat(scan->IntTime, 2*(47+rec));
    dffloat(scan->AirTemp, 2*77);
    dffloat(scan->Pressure, 2*78);
    dffloat(scan->Humidity, 2*79);
    dffloat((float)scan->VSource, 2*(49+rec));
    dffloat((float)scan->VelRes, 2*(51+rec));
    dfdble(scan->RestFreq, 70+3*rec);
    dfdble(scan->SkyFreq, 76+3*rec);
    dffloat((float)scan->Bandwidth, 2*(53+rec));
    next = twh+150; 
    if (rec == 1) next += (int)twh[55];
    for (i = 0; i < scan->NChannel; i++) {
#ifndef CONVEX
	scan->Channels[i] *= 4.0;
#endif
	*next++ = scan->Channels[i];
    }
}

int main(int argc, char *argv[])
{
    FILE *df = NULL;

    GetOpts(argc, argv);

    if (dfilname[0] == '\0') {
#ifdef CONVEX
    if (dfil == 0 || block == 0) DRPerror("file and block number required");
    who = getenv("USER");
    if (block < 1 || block > DFILBLOCK) 
      DRPerror("block number out of range");
    df = OpenDfil(dfil, blocklen, who, dfilname);
#endif
    } else df = fopen(dfilname, "r+");
    if (df == NULL) DRPerror("can't open dfile");

    GetScan(&OnScan);

    ReadDfilIndex(df, indx);
    indx[block-1] = OnScan.ScanNo;
    WriteDfilIndex(df, indx);

    itwh = (DFWORD *)calloc((unsigned)(blocklen*DFILBLOCK),sizeof(DFWORD));
    if (itwh == NULL) DRPerror("can't allocate scan");

    filltwh(&OnScan, receiver);
/*    Drp2Ants(&OnScan, itwh); */
    PutDfilBlock(df, block, blocklen, itwh);
    DRPinfo("scan %d written to block %d in file '%s'", 
	    OnScan.ScanNo, block, dfilname);
    exit(0);
}
