#include <math.h>
#include <ctype.h>
 
#ifndef HUGE_VAL
#define HUGE_VAL 1.0e308
#endif

#ifndef PI
#define PI 3.141592653589796
#endif

#define SECPERREV (360*60*60)
#define SECTORAD  2.0*PI/SECPERREV

#define REVS     'R'
#define HOUR     'H'
#define MIN      'M'
#define SEC      'S'
#define DEGREE   'D'
#define ARCMIN   '\''
#define ARCSEC   '\"'
#define EXPONENT 'E'
 
double atof();

double radian(char *w)
{
    double angle, sign, field, unit;
    int hit;
    register char *s;
 
    /* take care of leading minus and plus signs */
    if (*w == '-') { sign = -1.0; w++; }
    else           { sign =  1.0; if (*w == '+') w++; }
 
    unit = 1.0; 
    angle = 0.0;
    hit = 0;
    for (s = w; *w != '\0'; w++) {
	/* note that conversion factors are cumulative */
        switch (toupper(*w)) {
          case REVS:   	    unit *= 24.0;
          case HOUR:   	    unit *= 15.0;
          case DEGREE: 	    unit *= 4.0;
          case MIN:    	    unit *= 15.0;
          case ARCMIN: 	    unit *= 4.0;
          case SEC:    	    unit *= 15.0;
          case ARCSEC: 	    *w = '\0';
	    field = atof(s); 
	    angle += field*unit;
	    s = w+1;                  /* point past unit     */ 
	    unit = 1.0;               /* reset               */
	    hit++;                    /* count units         */
	    break;
	  case EXPONENT:
	    w++;                      /* check next char     */
	    if (isdigit(*w)) break;   /* digits are ok       */
	    if (*w == '-')   break;   /* minus sign is ok    */
	    if (*w == '+')   break;   /* plus sign is ok     */
	    return (HUGE_VAL);        /* everything else     */
          default:
	    if (isdigit(*w)) break;   /* digits are ok       */
	    if (*w == '.')   break;   /* decimal point is ok */
	    return (HUGE_VAL);        /* everything else     */
        }
    }
    /* if string contained no units just return number as is */
    if (!hit)   return (sign*atof(s));
    
    /* check if string ended in unit, if not we reject it    */
    if (s == w) return (angle*sign*SECTORAD);
    else        return (HUGE_VAL);
}
