#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "drp.h"
#include "options.h"

static float shift = 0.0;
static int unit = -1;

char PROGRAM_NAME[] = "shift";
char description[] = "change centre velocity or frequency by given amount";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{ "-vel shift",                 "shift in velocity" },
{ "-freq shift",                "shift in frequency" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt, *optarg;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    if (!strcmp(opt, "vel")) {
	GetOption(&optarg, pargc, pargv);
	shift = atof(optarg);
	unit = VELOCITY;
	return;
    }
    if (!strcmp(opt, "freq")) {
	GetOption(&optarg, pargc, pargv);
	shift = atof(optarg);
	unit = FREQUENCY;
	return;
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main(int argc, char *argv[])    
{
    GetOpts(argc, argv);
    if (unit == -1) {
	Syntax("");
	exit(0);
    }

    GetScan(&OnScan);

    switch (unit) {
      case VELOCITY:
	OnScan.VSource += (double)shift;
	OnScan.SkyFreq -= OnScan.RestFreq*shift/299792.458;
	OnScan.RestFreq -= OnScan.RestFreq*shift/299792.458;
	break;
      case FREQUENCY:
	OnScan.VSource -= 299792.458*shift/OnScan.RestFreq;
	OnScan.RestFreq += (double)shift;
	OnScan.SkyFreq += (double)shift;
	break;
    }

    PutScan(&OnScan);
    exit(0);
}
