#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"

char PROGRAM_NAME[] = "reverse";
char description[] = "turn order of channels around";
char required[] = "";
struct _options options[] = {
{ "-help",			"Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    Syntax(**pargv);
}

SCAN OnScan;
  
int main(int argc, char *argv[])
{
    float swap;
    int LastCh;
    int i;
  
    GetOpts(argc, argv);
    GetScan(&OnScan);
  
    LastCh = OnScan.NChannel-1;
    for (i = 0; i < OnScan.NChannel/2; i++) {
	swap = OnScan.Channels[i];
	OnScan.Channels[i] = OnScan.Channels[LastCh-i];
	OnScan.Channels[LastCh-i] = swap;
    }  
    OnScan.VelRes *= -1.0;
    OnScan.FreqRes *= -1.0;

    PutScan(&OnScan);
    exit(0);
}
