#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "drp.h"
#include "options.h"
  
float scale = 0.0;

char PROGRAM_NAME[] = "scale";
char description[] = "multiply spectrum by given factor";
char required[] = "factor";
struct _options options[] = {
{ "-help",			"Print out this message" },
{NULL, NULL }};

void ParseOpts(int *pargc, char ***pargv)
{
    char *opt;

    opt = (*pargv)[0] + 1;

    if (!strcmp(opt, "help")) {
	Help();
	exit(0);
    }
    Syntax(**pargv);
}

SCAN OnScan;

int main (int argc, char *argv[])
{
    int i;
  
    GetOpts(argc, argv);
    if (argc <= 1) {
	Syntax("");
	exit(EX_ARGSBAD);
    } else {
	scale = atof(argv[1]);
    }

    GetScan (&OnScan);
  
    for (i = 0; i < (int)OnScan.NChannel; i++) {
	OnScan.Channels[i] *= scale;
    }
  
    PutScan (&OnScan);
    exit(0);
}
