#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include "plplot.h"
#include "drp.h"
  
#define COVER 0
#define CONTR 1
#define SCANS 2
#define VALUE 3
#define SHADE 4
#define SPECT 5
  
#define READ  0

extern double xMin, xMax;
extern double yMin, yMax;
extern int xUnit;

extern int which;
extern int col;
extern int pen;
extern int frame;
extern int mark;
extern int title;
extern char markfile[];
extern char keyword[10];
extern char NewTitle[];
extern int label[];
extern char xLabel[], yLabel[];
extern float level, dl;

void scanio(char *, int , SCAN *);
void contour(float);
void grey(float, float, float, float, float, float);
  
#define MAXLEN 200
#define MAXCOL  10
#define MAXDIM 2000
/* PLFLT xp[MAXDIM], yp[MAXDIM]; */
  
static struct point {
    int mapx, mapy;
    float value;
} p[MAXDIM];
  
int pts;
float *height;            
float BLANK = 1000000.0;

SCAN OnScan, temp;

void KillJunk(char s[])
{
    int i,j;

    for (i=0, j=0; i<strlen(s); i++)
      if (isalnum(s[i])) s[j++] = s[i];
    s[j++] = '\0';
}

void offsets (int ipix, int jpix, float stepx, float stepy, float tilt, 
	 float *xoff, float *yoff)
{
    *xoff = ipix*stepx*cos(tilt)+jpix*stepy*sin(tilt);
    *yoff = jpix*stepy*cos(tilt)-ipix*stepx*sin(tilt);
}
  
void pixels (float xoff, float yoff, float stepx, float stepy, float tilt,
	int *ipix, int *jpix)
{
    *ipix = drpint((xoff*cos(tilt)-yoff*sin(tilt))/stepx);
    *jpix = drpint((xoff*sin(tilt)+yoff*cos(tilt))/stepy);
}

static float tmin, tmax;
static PLFLT xa[MAXCHANNELS];

static char scanname[20];
static char nextscan[20];

static int FirstCh, LastCh;
static double delta;
  
void scanlog(void)
{
    FILE *drplog;
    char record[MAXLEN], *com, *next;
    float ox = 0.0, oy = 0.0, v[MAXCOL];
    int no = 0, skip;
    float tilt, stepx, stepy;
    float xmin = 0.0, xmax = 0.0, ymin = 0.0, ymax = 0.0;
    int DimX, DimY;
    int imin = 0, imax = 0, jmin = 0, jmax = 0;
    int i, j, n, m;
 
    GetScan(&OnScan);
    /* for SPECT we use a scaling which fits the current scan */
    /* or take scaling from supplied runstring parameters     */
    if (which == SPECT) {
        if (yMin == 0 && yMax == 0) {
	    tmin = tmax = OnScan.Channels[0];
	    for (i=1; i<OnScan.NChannel; i++) {
	        if (OnScan.Channels[i] < tmin) tmin = OnScan.Channels[i];
		if (OnScan.Channels[i] > tmax) tmax = OnScan.Channels[i];
	    }
	} else {
	  tmin = yMin;
	  tmax = yMax;
	}
	if (xMin != 0.0 || xMax != 0.0) {
	    switch (xUnit) {
	      case VELOCITY:
		FirstCh = VChannel((double)xMin, &OnScan);
		LastCh  = VChannel((double)xMax, &OnScan);
		break;
	      case FREQUENCY:
		FirstCh = FChannel((double)xMin, &OnScan);
		LastCh  = FChannel((double)xMax, &OnScan);
		break;
	      case CHANNELS:
		FirstCh = (int)xMin;
		if (FirstCh < 0) {
		  FirstCh = 0;
		  xMin = (float)FirstCh;
		}
		LastCh  = (int)xMax;
		if (LastCh > OnScan.NChannel-1) {
		  LastCh = OnScan.NChannel-1;
		  xMax = (float)LastCh;
		}
	    }
	} else {
	    FirstCh = 0;
	    LastCh = OnScan.NChannel-1;
	}
	if (LastCh < FirstCh) {
	    n = FirstCh;
	    FirstCh = LastCh;
	    LastCh = n;
	}
	switch (xUnit) {
	  case VELOCITY:
	    delta = OnScan.VelRes;
	    break;
	  case FREQUENCY:
	    delta = OnScan.FreqRes;
	    break;
	  case CHANNELS:
	    delta = 1.0;
	    break;
	}
	strncpy(scanname, OnScan.Name, 12);
	KillJunk(scanname);
    }
    stepx = OnScan.StepX; stepx *= RADTOMIN;
    stepy = OnScan.StepY; stepy *= RADTOMIN;
    tilt = OnScan.PosAngle;
    if (stepx == 0.0 || stepy == 0.0) DRPerror("zero map spacing");
  
    drplog = fopen("drp.log", "r");
    if (drplog == NULL) DRPerror("couldn't open log file");

    /*
     * scan the log file (DRP.LOG) for entries and store them by writing
     * over the channel values in OnScan.
     */
    n = col;
    pts = 0;			/* count the entries */
    while (fgets(record, MAXLEN, drplog)) {
	com = strtok(record, ":");

	next = strtok(NULL,"\t\n\0");
	if (next) no = atoi(next);
	else DRPwarning("syntax error in file 'drp.log'");

	next = strtok(NULL,"\t\n\0");
	if (next) ox = atof(next);
	else DRPwarning("syntax error in file 'drp.log'");

	next = strtok(NULL,"\t\n\0");
	if (next) oy = atof(next);
	else DRPwarning("syntax error in file 'drp.log'");

	skip = strncmp(keyword, com, strlen(keyword));
	if (!skip) {
	    for (i=0; i<MAXCOL; i++) {
		next = strtok(NULL,"\t\n\0");
		if (next) v[i] = atof(next);
		else break;
	    }
	    pixels(ox, oy, stepx, stepy, tilt, 
		   &(p[pts].mapx), &(p[pts].mapy));
	    p[pts].value = v[n-1];
	    if (which == SCANS) p[pts].value = no;
	    if (which == SPECT) p[pts].value = no;
	    if (pts == 0) {
		imin = imax = p[pts].mapx;
		jmin = jmax = p[pts].mapy;
	    } else {
		if (imin > p[pts].mapx) imin = p[pts].mapx;
		if (imax < p[pts].mapx) imax = p[pts].mapx;
		if (jmin > p[pts].mapy) jmin = p[pts].mapy;
		if (jmax < p[pts].mapy) jmax = p[pts].mapy;
	    }
	    pts++;
	    if (pts > MAXDIM) DRPerror("too many entries");

/*	    printf("scanlog -- %f %f: %f\n", ox, oy, v[col-1]); */
	}
    }
    fclose(drplog);
    if (pts == 0) DRPerror("no data found");
 
    DimX = imax-imin+1;
    DimY = jmax-jmin+1;
    height = (float *)calloc(DimX*DimY, sizeof(float));
    if (height == (float *)NULL) DRPerror("memory allocation failure");
  
    offsets(imin, jmin, stepx, stepy, tilt, &OnScan.work[0], &OnScan.work[1]);
    offsets(imax, jmin, stepx, stepy, tilt, &OnScan.work[2], &OnScan.work[3]);
    offsets(imax, jmax, stepx, stepy, tilt, &OnScan.work[4], &OnScan.work[5]);
    offsets(imin, jmax, stepx, stepy, tilt, &OnScan.work[6], &OnScan.work[7]);
    if (tilt >= 0.0 && tilt < PI/2.0) {
	xmin = OnScan.work[0]; xmax = OnScan.work[4];
	ymin = OnScan.work[3]; ymax = OnScan.work[7];
    } else if (tilt >= PI/2.0 && tilt < PI) {
	xmin = OnScan.work[2]; xmax = OnScan.work[6];
	ymin = OnScan.work[5]; ymax = OnScan.work[1];
    } else if (tilt >= PI && tilt < 3.0*PI/2.0) {
	xmin = OnScan.work[4]; xmax = OnScan.work[0];
	ymin = OnScan.work[7]; ymax = OnScan.work[3];
    } else if (tilt >= 3.0*PI/2.0 && tilt < 2.0*PI) {
	xmin = OnScan.work[6]; xmax = OnScan.work[2];
	ymin = OnScan.work[1]; ymax = OnScan.work[5];
    }
    xmin -= stepx; xmax += stepx;
    ymin -= stepy; ymax += stepy;
  
    /**********************************************
      printf ("imin,jmin,imax,jmax: %d %d %d %d\n", imin,jmin,imax,jmax);
      printf ("DimX,DimY: %d %d\n", DimX, DimY);
      printf ("xmin,ymin,xmax,ymax: %f %f %f %f\n", xmin,ymin,xmax,ymax);
      **********************************************/
  
    /* now loop through grid */
    n = 0;
    for (j=jmin; j<=jmax; j++) {
	for (i=imin; i<=imax; i++) {
	    height[n++] = BLANK;
	}
    }
    for (n=0; n<pts; n++) {
	i = p[n].mapx; 
	j = p[n].mapy; 
	m = (i-imin)+(j-jmin)*DimX;
	height[m] = p[n].value;
    }
  
    OnScan.work[0] = xmin;
    OnScan.work[1] = xmax;
    OnScan.work[2] = ymin;
    OnScan.work[3] = ymax;
  
    OnScan.flag[0] = imin;
    OnScan.flag[1] = imax;
    OnScan.flag[2] = jmin;
    OnScan.flag[3] = jmax;
  
    OnScan.flag[4] = pts;
}
  

void scale(float min, float max, int nm, float *first, float *inc)
{
    float start, step, fak, swap;
    int intstep;
  
    if (min > max) {
	swap = min;
	min = max;
	max = swap;
    }
  
    if (min > 0.0 && min-(max-min)/4.0 < 0.0) min = 0.0;
    if (max < 0.0 && max+(max-min)/4.0 > 0.0) max = 0.0;
  
    step = (max-min)/nm;
    fak = pow((float)(10.0),floor(log10(step)));
    intstep = (int)(step/fak);
  
    switch (intstep) {
      case 1:  intstep = 2;
	break;
      case 2:
      case 3:
      case 4:  intstep = 5;
	break;
      case 5:
      case 6:
      case 7:  intstep = 8;
	break;
      case 8:
      case 9:  intstep = 10;
    }
    step = intstep*fak;
    if (min <= 0.0 && max > 0.0) {
	start = 0.0;
	while (start-step > min) start -= step;
    }
    else {
	fak *= 10.0;
	start = floor(min/fak)*fak;
	while (start + step <= min) start += step;
    }
    *first = start;
    *inc = step;
}

void showmap(void)
{
    FILE *mf;
    float xmin, xmax, ymin, ymax, dx, dy, x, y;
    float stepx, stepy, tilt;
    float hmin = 0.0, hmax = 0.0, hval, h;
    int i, j, n, pts, nch;
    char str[10];
  
    stepx = OnScan.StepX; stepx *= RADTOMIN;
    stepy = OnScan.StepY; stepy *= RADTOMIN;
    tilt  = OnScan.PosAngle;
  
    xmin = OnScan.work[0];
    xmax = OnScan.work[1];
    ymin = OnScan.work[2];
    ymax = OnScan.work[3];
  
    pts  = OnScan.flag[4];
  
    if (frame) {
	plenv((PLFLT)xmax, (PLFLT)xmin, (PLFLT)ymin, (PLFLT)ymax, 1, 0);
	if (!title) {
	    strncpy(NewTitle, OnScan.Name, 12);
	    NewTitle[12]='\0';
	}
	if (!label[0]) strcpy(xLabel, "offset [arcmin]");
	if (!label[1]) strcpy(yLabel, "offset [arcmin]");
	pllab(xLabel, yLabel, NewTitle);
    } else {
	plenv((PLFLT)xmax, (PLFLT)xmin, (PLFLT)ymin, (PLFLT)ymax, 1, -2);
    }
  
    if ((which == SCANS) || (which == VALUE)) plschr((PLFLT)0.0, (PLFLT)0.5);
    for (n=0; n<pts; n++) {
	offsets (p[n].mapx, p[n].mapy, stepx, stepy, tilt, &x, &y);
	switch (which) {
	  case COVER:
	    plpoin(1, (PLFLT *)&x, (PLFLT *)&y, 2);
	    break;
	  case SCANS:
	  case VALUE:
	    if (which == SCANS) sprintf(str, "%03d", (int)p[n].value);
	    if (which == VALUE) sprintf(str, "%.3f", p[n].value);
	    /* if (which == VALUE) sprintf(str, "%.1f", p[n].value); */
	    plptex((PLFLT)x,(PLFLT)y,(PLFLT)-1.0,(PLFLT)0.0,(PLFLT)0.5, str);
	    break;
	  case CONTR:
	  case SHADE:
	    if ((which == CONTR) && frame) { 
		plpoin(1, (PLFLT *)&x, (PLFLT *)&y, 1);
	    }
	    if (n == 0) hmin = hmax = p[n].value;
	    else {
		hval = p[n].value;
		if (hmin > hval) hmin = hval;
		if (hmax < hval) hmax = hval;
	    }
	    break;
	  case SPECT:
	    strcpy(nextscan, scanname);
	    sprintf(str, ".%04d", (int)p[n].value);
	    strcat(nextscan, str);
	    scanio(nextscan, READ, &temp);
	    xa[0] = (PLFLT)x - 0.5*stepx;
	    xa[1] = (PLFLT)x + 0.5*stepx;
	    xa[2] = (PLFLT)x + 0.5*stepx;
	    xa[3] = (PLFLT)x - 0.5*stepx;
	    xa[4] = (PLFLT)x - 0.5*stepx;

	    xa[5] = (PLFLT)y - 0.5*stepy;
	    xa[6] = (PLFLT)y - 0.5*stepy;
	    xa[7] = (PLFLT)y + 0.5*stepy;
	    xa[8] = (PLFLT)y + 0.5*stepy;
	    xa[9] = (PLFLT)y - 0.5*stepy;
	    plline(5, xa, xa+5);

	    nch = LastCh-FirstCh+1;
	    for (i = FirstCh; i <= LastCh; i++) {
	        j = i-FirstCh;
		xa[j] = ((PLFLT)j/(nch-1) - 0.5)*0.95*stepx;
		if (delta < 0.0) xa[j] = -xa[j];
		xa[j] += (PLFLT)x;
		if (temp.Channels[i] < tmin) temp.Channels[i] = tmin;
		if (temp.Channels[i] > tmax) temp.Channels[i] = tmax;
		temp.Channels[j] = (temp.Channels[i]-tmin)/(tmax-tmin) - 0.5;
		temp.Channels[j] *= 0.95*stepy;
		temp.Channels[j] += (PLFLT)y;
	    }
	    plline(nch, xa, temp.Channels);
	    break;
	}
    }

    if (which == CONTR) {
	if (level == 0.0 && dl == 0.0)  scale(hmin, hmax, 8, &level, &dl);
	if (dl == 0.0) dl = hmax-level+1;
	plcol(col);
	pllsty(pen);
	for (h = level; h<hmax; h += dl) {
	    contour(h);
	}
    }

    if (which == SHADE) {
	for (n=0; n<pts; n++) {
	    offsets (p[n].mapx, p[n].mapy, stepx, stepy, tilt, &x, &y);
	    if (level == 0.0 && dl == 0.0) {
		h = (p[n].value-hmin)/(hmax-hmin);
	    } else {
		h = (p[n].value-level)/dl/10.0;
		if (h < 0.0) h = 0.0;
		if (h > 1.0) h = 1.0;
	    }
	    grey(h, x, y, stepx, stepy, tilt);
	}
    }

    if (mark) {
	plcol(16);
	mf = fopen(markfile, "r");
	if (mf == NULL) {
	    DRPwarning("can't open file '%s'", markfile);
	    return;
	}
	while (!feof(mf)) {
	    i = fscanf(mf, "%f %f %d\n", &dx, &dy, &n);
	    if (i == 3) {
		plpoin(1, &dx, &dy, n);
	    }
	}
    }
}


